/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl.util.wx.transfer;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ptteng.rent.etl.util.wx.transfer.ConfigUtil;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.springframework.core.io.ClassPathResource;

public class HttpKit {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int CONNECT_TIME_OUT = 5000;
    private static SSLContext wx_ssl_context = null;

    public static String get(String url, Map<String, String> params, Map<String, String> headers) {
        Set<String> keys;
        AsyncHttpClient http = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setConnectTimeout(5000).build());
        AsyncHttpClient.BoundRequestBuilder builder = http.prepareGet(url);
        builder.setBodyEncoding(DEFAULT_CHARSET);
        if (params != null && !params.isEmpty()) {
            keys = params.keySet();
            for (String key : keys) {
                builder.addQueryParam(key, params.get(key));
            }
        }
        if (headers != null && !headers.isEmpty()) {
            keys = headers.keySet();
            for (String key : keys) {
                builder.addHeader(key, params.get(key));
            }
        }
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        http.close();
        return body;
    }

    public static String get(String url) {
        return HttpKit.get(url, null);
    }

    public static String get(String url, Map<String, String> params) {
        return HttpKit.get(url, params, null);
    }

    public static String post(String url, Map<String, String> params) {
        AsyncHttpClient http = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setConnectTimeout(5000).build());
        AsyncHttpClient.BoundRequestBuilder builder = http.preparePost(url);
        builder.setBodyEncoding(DEFAULT_CHARSET);
        if (params != null && !params.isEmpty()) {
            Set<String> keys = params.keySet();
            for (String key : keys) {
                builder.addQueryParam(key, params.get(key));
            }
        }
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        http.close();
        return body;
    }

    public static String post(String url, String s) {
        AsyncHttpClient http = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setConnectTimeout(5000).build());
        AsyncHttpClient.BoundRequestBuilder builder = http.preparePost(url);
        builder.setBodyEncoding(DEFAULT_CHARSET);
        builder.setBody(s);
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        http.close();
        return body;
    }

    public static String posts(String url, Map<String, String> params) {
        AsyncHttpClient http = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setConnectTimeout(5000).setSSLContext(wx_ssl_context).build());
        AsyncHttpClient.BoundRequestBuilder bbuilder = http.preparePost(url);
        bbuilder.setBodyEncoding(DEFAULT_CHARSET);
        if (params != null && !params.isEmpty()) {
            Set<String> keys = params.keySet();
            for (String key : keys) {
                bbuilder.addQueryParam(key, params.get(key));
            }
        }
        ListenableFuture f = bbuilder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        http.close();
        return body;
    }

    public static String posts(String url, String s) {
        AsyncHttpClient http = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setConnectTimeout(5000).setSSLContext(wx_ssl_context).build());
        AsyncHttpClient.BoundRequestBuilder builder = http.preparePost(url);
        builder.setBodyEncoding(DEFAULT_CHARSET);
        builder.setBody(s);
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        http.close();
        return body;
    }

    static {
        ClassPathResource resource = new ClassPathResource("wx_apiclient_cert.p12");
        char[] keyStorePassword = ConfigUtil.getProperty("wx.mchid").toCharArray();
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(resource.getInputStream(), keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, keyStorePassword);
            SSLContext wx_ssl_context = SSLContext.getInstance("TLS");
            wx_ssl_context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

