/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl.util.wx.transfer;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DatetimeUtil {
    public static final String DATETIME_PATTERN = "yyyyMMddHHmmss";
    public static final String TIME_STAMP_PATTERN = "yyyyMMddHHmmssSSS";
    public static final String DATE_PATTERN = "yyyyMMdd";
    public static final String TIME_PATTERN = "HHmmss";
    public static final String STANDARD_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String STANDARD_DATETIME_PATTERN_HM = "yyyy-MM-dd HH:mm";
    public static final String STANDARD_DATE_PATTERN = "yyyy-MM-dd";
    public static final String STANDARD_TIME_PATTERN = "HH:mm:ss";
    public static final String STANDARD_DATETIME_PATTERN_SOLIDUS = "yyyy/MM/dd HH:mm:ss";
    public static final String STANDARD_DATETIME_PATTERN_SOLIDUS_HM = "yyyy/MM/dd HH:mm";
    public static final String STANDARD_DATE_PATTERN_SOLIDUS = "yyyy/MM/dd";

    private DatetimeUtil() {
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String currentDatetime() {
        return DatetimeUtil.formatDate(new Date());
    }

    public static Timestamp parseDate(String dateStr, String pattern) throws ParseException {
        Date d = DatetimeUtil.parse(dateStr, pattern);
        return new Timestamp(d.getTime());
    }

    public static Timestamp parseDate(String dateStr) throws ParseException {
        return DatetimeUtil.parseDate(dateStr, STANDARD_DATE_PATTERN);
    }

    public static java.sql.Date parseSQLDate(String dateStr, String pattern) throws ParseException {
        Date d = DatetimeUtil.parse(dateStr, pattern);
        return new java.sql.Date(d.getTime());
    }

    public static java.sql.Date parseSQLDate(String dateStr) throws ParseException {
        Date d = DatetimeUtil.parse(dateStr, STANDARD_DATE_PATTERN);
        return new java.sql.Date(d.getTime());
    }

    public static Timestamp getFutureTime(int month) {
        Calendar c = Calendar.getInstance();
        c.add(2, month);
        return new Timestamp(c.getTimeInMillis());
    }

    public static String today() {
        return DatetimeUtil.formatDateTime(new Date());
    }

    public static String formatDate(Timestamp t) {
        return DatetimeUtil.formatDate(new Date(t.getTime()));
    }

    public static String formatDate(Timestamp t, String pattern) {
        return DatetimeUtil.formatDate(new Date(t.getTime()), STANDARD_DATE_PATTERN);
    }

    public static String formatDateTime(Timestamp t, String pattern) {
        return DatetimeUtil.formatDate(new Date(t.getTime()), STANDARD_DATETIME_PATTERN);
    }

    public static String formatDate(Date date) {
        return DatetimeUtil.formatDate(date, STANDARD_DATE_PATTERN);
    }

    public static String formatDateTime(Date date) {
        return DatetimeUtil.formatDate(date, STANDARD_DATETIME_PATTERN);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static Date parse(String dateStr) {
        return DatetimeUtil.parse(dateStr, STANDARD_DATE_PATTERN);
    }

    public static Date parseTime(String dateStr) {
        return DatetimeUtil.parse(dateStr, STANDARD_DATETIME_PATTERN);
    }

    public static Date parse(String dateStr, String pattern) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String firstDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        return DatetimeUtil.formatDate(calendar.getTime()) + " 00:00:00";
    }

    public static String lastDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        calendar.set(5, 0);
        return DatetimeUtil.formatDate(calendar.getTime()) + " 23:59:59";
    }
}

