/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl;

import com.ptteng.rent.etl.util.CommentCountUtils;
import com.ptteng.rent.etl.util.DynamicUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.UserCommentCount;
import com.ptteng.rent.user.service.OrdersService;
import com.ptteng.rent.user.service.UserCommentCountService;
import com.ptteng.rent.user.service.UserCommentRelationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrdersTestEvaluationEtl {
    private static final Log log = LogFactory.getLog(OrdersTestEvaluationEtl.class);
    private OrdersService ordersService;
    private UserCommentRelationService userCommentRelationService;
    private UserCommentCountService userCommentCountService;
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 15000L;
    private Long interval = 2000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    log.info((Object)"--------------ETL 4-----------------");
                    log.info((Object)"find not evaluation normal end orders etl is start!");
                    List<Orders> notEvaluationNormalEndOrderList = this.findNotEvaluationNormalEndOrders();
                    log.info((Object)("not evaluation normal end order list size :" + notEvaluationNormalEndOrderList.size()));
                    if (CollectionUtils.isEmpty(notEvaluationNormalEndOrderList)) {
                        log.info((Object)"orders push etl not get any id ,sleep 15000 ms ");
                    } else {
                        this.processOrder(notEvaluationNormalEndOrderList);
                    }
                    Thread.sleep(15000L);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(15000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<Orders> findNotEvaluationNormalEndOrders() {
        log.info((Object)"============------------===============");
        log.info((Object)"find not evaluation normal end order method start!!!");
        List notEvaluationNormalEndOrderList = new ArrayList();
        ArrayList<Orders> notEvaluationNormalEndOrderResultList = new ArrayList<Orders>();
        Map<String, Object> conditions = DynamicUtil.getNotEvaluationNormalEntOrders();
        log.info((Object)("get normal end order params \uff1b" + conditions));
        try {
            List notEvaluationNormalEndOrderIds = this.ordersService.getIdsByDynamicCondition(Orders.class, conditions, Integer.valueOf(0), Integer.valueOf(100));
            if (CollectionUtils.isNotEmpty((Collection)notEvaluationNormalEndOrderIds)) {
                notEvaluationNormalEndOrderList = this.ordersService.getObjectsByIds(notEvaluationNormalEndOrderIds);
            }
            for (Orders orders : notEvaluationNormalEndOrderList) {
                Long interval = System.currentTimeMillis() - orders.getEndOfOrderAt();
                log.info((Object)("interval is :" + interval));
                if (interval < Orders.ONE_DAY) continue;
                notEvaluationNormalEndOrderResultList.add(orders);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t);
        }
        return notEvaluationNormalEndOrderResultList;
    }

    private void processOrder(List<Orders> notEvaluationNormalEndOrderList) throws Exception {
        log.info((Object)"***********************************");
        log.info((Object)"Transfer to lessor");
        boolean b = this.ordersService.randomSetUserCommentCount(notEvaluationNormalEndOrderList);
        log.info((Object)b);
    }

    public OrdersService getOrdersService() {
        return this.ordersService;
    }

    public void setOrdersService(OrdersService ordersService) {
        this.ordersService = ordersService;
    }

    public UserCommentRelationService getUserCommentRelationService() {
        return this.userCommentRelationService;
    }

    public UserCommentCountService getUserCommentCountService() {
        return this.userCommentCountService;
    }

    public void setUserCommentRelationService(UserCommentRelationService userCommentRelationService) {
        this.userCommentRelationService = userCommentRelationService;
    }

    public void setUserCommentCountService(UserCommentCountService userCommentCountService) {
        this.userCommentCountService = userCommentCountService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    private void getCommentCount(List<String> commentList, Long uid) throws Exception {
        List userCommentCountIds = this.userCommentCountService.getUserCommentCountIdsByUid(uid, Integer.valueOf(0), Integer.valueOf(10));
        if (CollectionUtils.isEmpty((Collection)userCommentCountIds)) {
            UserCommentCount userCount = new UserCommentCount();
            log.info((Object)("-------------------" + userCount));
            CommentCountUtils.countComment(commentList, userCount);
            userCount.setUid(uid);
            Long userCommentCountId = this.userCommentCountService.insert(userCount);
            log.info((Object)("user comment count id is :" + userCommentCountId));
        } else {
            Long userCommentCountId = (Long)userCommentCountIds.get(0);
            UserCommentCount userCommentCount = this.userCommentCountService.getObjectById(userCommentCountId);
            CommentCountUtils.countComment(commentList, userCommentCount);
            boolean b = this.userCommentCountService.update(userCommentCount);
            if (b) {
                log.info((Object)"userCommentCount update success");
            } else {
                log.info((Object)"userCommentCount update fail");
                throw new Exception("update UserCommentCount Exception");
            }
        }
    }
}

