package com.ptteng.rent.etl.util;

import com.ptteng.rent.user.model.UserCommentCount;

import java.util.*;

/**
 * @author cjsff
 * 2018/7/1
 * 随机获取评论内容
 */
public class RandomCommentUtil {

    public static String getRandomComment() {

        String[] constantComment = {UserCommentCount.FIELD1, UserCommentCount.FIELD2, UserCommentCount.FIELD3,
                UserCommentCount.FIELD4, UserCommentCount.FIELD5, UserCommentCount.FIELD6, UserCommentCount.FIELD7,
                UserCommentCount.FIELD8, UserCommentCount.FIELD13, UserCommentCount.FIELD14};

        String[] newRandomArray = getRandomArray(constantComment, 5);

        StringBuffer stringBuffer = new StringBuffer();

        for (int i = 0; i < newRandomArray.length; i++) {

            stringBuffer.append(newRandomArray[i]);

            if (i >= 4) {
                break;
            }

            stringBuffer.append(",");

        }

        return String.valueOf(stringBuffer);
    }

    /**
     * @param paramArray:被抽取数组
     * @param count:抽取元素的个数
     * @function:从数组中随机抽取若干不重复元素
     * @return:由抽取元素组成的新数组
     */
    private static String[] getRandomArray(String[] paramArray, int count) {

        if (paramArray.length < count) {

            return paramArray;

        }

        String[] newArray = new String[count];

        Random random = new Random();

        int temp = 0;//接收产生的随机数

        List<Integer> list = new ArrayList<Integer>();

        for (int i = 1; i <= count; i++) {

            // 将产生的随机数作为被抽数组的索引
            temp = random.nextInt(paramArray.length);

            if (!(list.contains(temp))) {

                newArray[i - 1] = paramArray[temp];

                list.add(temp);

            } else {

                i--;

            }

        }

        return newArray;

    }

}
