package com.ptteng.rent.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.rent.etl.util.DynamicUtil;
import com.ptteng.rent.etl.util.TransferUtils;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.User;
import com.ptteng.rent.user.service.OrdersService;
import com.ptteng.rent.user.service.UserService;
import com.qding.community.common.weixin.service.WeiXinService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author cjsff
 * 查询正常结束订单，并给出租人转账
 */
public class OrdersFindNormalEndEtl {

    private static final Log log = LogFactory.getLog(OrdersFindNormalEndEtl.class);

    private OrdersService ordersService;

    private UserService userService;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    private WeiXinService weixinService;

    /**
     * 一次任务检测多少条数据
     */
    private static final int TASK_LEN = 100;

    /**
     * 空转任务间隔休息毫秒数
     */
    private static final long SLEEP_MILLISECOND = 15000;

    private Long interval = 2000L;

    public OrdersFindNormalEndEtl() {
        super();
    }

    public void process() throws InterruptedException {

        while (true) {

            try {

                log.info("--------------ETL 2-----------------");

                log.info("find normal orders etl is start!");

                // 查询正常结束的订单
                List<Orders> normalEndOrderList = findNormalEndOrders();

                log.info("normal end order list size :" + normalEndOrderList.size());

                if (CollectionUtils.isEmpty(normalEndOrderList)) {

                    log.info("orders push etl not get any id ,sleep " + SLEEP_MILLISECOND + " ms ");

//                    Thread.sleep(SLEEP_MILLISECOND);

                }else {
                    processOrder(normalEndOrderList);
                }
                //成功失败都要休眠
                Thread.sleep(SLEEP_MILLISECOND);

            } catch (Throwable t) {

                t.printStackTrace();

                Thread.sleep(SLEEP_MILLISECOND);

                log.error("process goods bytime status error ,sleep " + t.getMessage());

            }

        }

    }


    /**
     * 查询正常结束订单(租赁时间正常结束，双方都已评价)
     * @return
     */
    private List<Orders> findNormalEndOrders() {

        log.info("============------------===============");

        log.info("find normal end order method start!!!");

        List<Orders> normalEndOrderList = new ArrayList();

        Map<String, Object> conditions = DynamicUtil.getNormalEndOrderList();

        log.info("get normal end order params ；" + conditions);

        try {

            List<Long> normalEndOrderIds = this.ordersService.getIdsByDynamicCondition(Orders.class, conditions,
                    0, TASK_LEN);

            if (CollectionUtils.isNotEmpty(normalEndOrderIds)) {

                normalEndOrderList = this.ordersService.getObjectsByIds(normalEndOrderIds);

            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
        }

        return normalEndOrderList;
    }


    /**
     * 给出租人转账
     * @param normaoEndOrderList
     * @throws ServiceException
     * @throws ServiceDaoException
     * @throws InterruptedException
     * @throws IOException
     */
    private void processOrder(List<Orders> normaoEndOrderList) throws ServiceException, ServiceDaoException,
            InterruptedException,
            IOException {

        log.info("***********************************");

        log.info("Transfer to lessor");

        if (CollectionUtils.isNotEmpty(normaoEndOrderList)) {

            for (Orders orders : normaoEndOrderList) {

                Long lessorId = orders.getLessorId();

                log.info("lessorId is :" + lessorId);

                log.info("给出租人转账！！！！！！！！！！！！！！！！！");

                String sql = "select open_id from user where id = " + lessorId;

                String lessorOpenid = jdbcTemplate.queryForObject(sql, String.class);

                log.info("lessor openid is :" + lessorOpenid);

                BigDecimal ordersPrice = orders.getPrice().subtract(orders.getLessorServiceFee());

                log.info("orders lessor get money is :" + ordersPrice);

                String userStatusSQL = "select user_status from user where id = " + lessorId;

                Integer userStatus = jdbcTemplate.queryForInt(userStatusSQL);

                log.info("user status is :" + userStatus);

                //  给出租人转账
                //  只给实名认证的用户转账
//                if (User.USER_STATUS_VERIFIED.equals(userStatus)) {

                    int code = TransferUtils.transferPay(lessorOpenid, ordersPrice.multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString(), orders.getOrderNo());

                    log.info("code is :" + code);

                    if (code == 0) {

                        orders.setStatus(Orders.TRANSFERRED);

                    }

//                }else {
//                    log.info("未实名，不走转账流程");
//                }



            }

            boolean boo = ordersService.updateList(normaoEndOrderList);

            if (boo) {

                log.info("order update status success");

            } else {

                log.info("order update status fail");

                log.info("-------------------------");

            }

        }

    }


    public OrdersService getOrdersService() {
        return ordersService;
    }

    public void setOrdersService(OrdersService ordersService) {
        this.ordersService = ordersService;
    }

    public Long getInterval() {
        return interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public UserService getUserService() {
        return userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}
