/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.discount;

import com.ptteng.micro.mall.constant.DiscountEnum;
import com.ptteng.micro.mall.model.Coupon;
import com.ptteng.micro.mall.model.Promotion;
import com.ptteng.micro.mall.pojo.DiscountDetailDTO;
import com.ptteng.micro.mall.util.CopyUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractDiscountCalculator {
    public DiscountDetailDTO calculateForCoupon(Coupon coupon, List<DiscountDetailDTO.DiscountItem> items) throws Exception {
        DiscountDetailDTO discountDetailDTO = this.getDiscountDetailForCoupon(coupon);
        return this.calculate(discountDetailDTO, items);
    }

    public DiscountDetailDTO calculateForPromotion(Promotion promotion, List<DiscountDetailDTO.DiscountItem> items) throws Exception {
        DiscountDetailDTO discountDetailDTO = this.getDiscountDetailForPromotion(promotion);
        return this.calculate(discountDetailDTO, items);
    }

    protected abstract DiscountDetailDTO getDiscountDetailForCoupon(Coupon var1) throws Exception;

    protected abstract DiscountDetailDTO getDiscountDetailForPromotion(Promotion var1) throws Exception;

    protected abstract DiscountDetailDTO calculate(DiscountDetailDTO var1, List<DiscountDetailDTO.DiscountItem> var2);

    protected DiscountDetailDTO finalDiscount(DiscountDetailDTO discountDetailDTO, List<DiscountDetailDTO.DiscountItem> finalItems) {
        if (discountDetailDTO == null || CollectionUtils.isEmpty(finalItems)) {
            return discountDetailDTO;
        }
        List<DiscountDetailDTO.DiscountItem> applicableItems = discountDetailDTO.getItems();
        BigDecimal finalDiscountAmount = BigDecimal.ZERO;
        for (DiscountDetailDTO.DiscountItem finalItem : finalItems) {
            for (DiscountDetailDTO.DiscountItem applicableItem : applicableItems) {
                if (!finalItem.getSkuId().equals(applicableItem.getSkuId())) continue;
                BigDecimal itemTotalAmount = finalItem.getTotalAmount();
                BigDecimal existingDiscount = finalItem.getDiscountAmount();
                BigDecimal discountAmount = applicableItem.getDiscountAmount();
                BigDecimal maxAllowedDiscount = itemTotalAmount.subtract(existingDiscount);
                BigDecimal actualDiscount = discountAmount.min(maxAllowedDiscount);
                finalDiscountAmount = finalDiscountAmount.add(actualDiscount);
                finalItem.setDiscountAmount(existingDiscount.add(actualDiscount));
                finalItem.setActualPayAmount(itemTotalAmount.subtract(finalItem.getDiscountAmount()).max(BigDecimal.ZERO));
            }
        }
        List<DiscountDetailDTO.DiscountItem> finalItemsCopy = CopyUtil.deepCopyList(finalItems);
        discountDetailDTO.setFinalItems(finalItemsCopy);
        discountDetailDTO.setFinalDiscountAmount(finalDiscountAmount.setScale(2, RoundingMode.HALF_UP));
        return discountDetailDTO;
    }

    protected List<DiscountDetailDTO.DiscountItem> applicableItem(DiscountDetailDTO discountDetailDTO, List<DiscountDetailDTO.DiscountItem> items) {
        if (discountDetailDTO == null || CollectionUtils.isEmpty(items) || CollectionUtils.isEmpty(discountDetailDTO.getSkuIds())) {
            return Collections.emptyList();
        }
        ArrayList<DiscountDetailDTO.DiscountItem> applicableItems = new ArrayList<DiscountDetailDTO.DiscountItem>();
        for (DiscountDetailDTO.DiscountItem item : items) {
            if (!discountDetailDTO.getSkuIds().contains(item.getSkuId()) || item.getCnt() <= 0) continue;
            discountDetailDTO.getHitSkuIds().add(item.getSkuId());
            DiscountDetailDTO.DiscountItem copy = new DiscountDetailDTO.DiscountItem();
            copy.setSkuId(item.getSkuId());
            copy.setSpuId(item.getSpuId());
            copy.setOriginalPrice(item.getOriginalPrice());
            copy.setTotalAmount(item.getTotalAmount());
            copy.setDiscountAmount(item.getDiscountAmount());
            copy.setActualPayAmount(item.getActualPayAmount());
            copy.setExchange(item.getExchange());
            copy.setCnt(item.getCnt());
            copy.setDiscountRate(item.getDiscountRate());
            copy.setRateDiscountAmount(item.getRateDiscountAmount());
            applicableItems.add(copy);
        }
        return applicableItems;
    }

    public static enum DiscountType {
        NULL(-1, -1, -1, "\u672a\u5b9a\u4e49\u7684\u6298\u6263\u7c7b\u578b"),
        COUPON_EXCHANGE(DiscountEnum.COUPON.getCode(), Coupon.CATEGORY_EXCHANGE, Coupon.TYPE_EXCHANGE, "\u5151\u6362\u5238"),
        COUPON_THRESHOLD_REDUCTION(DiscountEnum.COUPON.getCode(), Coupon.CATEGORY_THRESHOLD, Coupon.TYPE_THRESHOLD_REDUCTION, "\u95e8\u69db\u6ee1\u51cf\u5238"),
        COUPON_THRESHOLD(DiscountEnum.COUPON.getCode(), Coupon.CATEGORY_THRESHOLD, Coupon.TYPE_THRESHOLD, "\u65e0\u95e8\u69db\u6ee1\u51cf\u5238"),
        COUPON_DISCOUNT_REDUCTION(DiscountEnum.COUPON.getCode(), Coupon.CATEGORY_DISCOUNT, Coupon.TYPE_THRESHOLD_REDUCTION, "\u95e8\u69db\u6298\u6263\u5238"),
        COUPON_DISCOUNT(DiscountEnum.COUPON.getCode(), Coupon.CATEGORY_DISCOUNT, Coupon.TYPE_THRESHOLD, "\u65e0\u95e8\u69db\u6298\u6263\u5238"),
        PROMOTION_THRESHOLD_LOOP(DiscountEnum.PROMOTION.getCode(), Promotion.CATEGORY_THRESHOLD_LOOP, 0, "\u6bcf\u6ee1\u51cf\u6d3b\u52a8"),
        PROMOTION_GIFT(DiscountEnum.PROMOTION.getCode(), Promotion.CATEGORY_GIFT, 0, "\u6ee1\u8d60\u6d3b\u52a8"),
        PROMOTION_THRESHOLD_GIFT(DiscountEnum.PROMOTION.getCode(), Promotion.CATEGORY_THRESHOLD_GIFT, 0, "\u6ee1\u51cf\u6d3b\u52a8");

        private final int type;
        private final int discountCategory;
        private final int discountType;
        private final String desc;

        public int getType() {
            return this.type;
        }

        public int getDiscountCategory() {
            return this.discountCategory;
        }

        public int getDiscountType() {
            return this.discountType;
        }

        public String getDesc() {
            return this.desc;
        }

        private DiscountType(int type, int discountCategory, int discountType, String desc) {
            this.type = type;
            this.discountCategory = discountCategory;
            this.discountType = discountType;
            this.desc = desc;
        }

        public static DiscountType getDiscountType(Coupon coupon) {
            if (Objects.equals(coupon.getCategory(), Coupon.CATEGORY_EXCHANGE)) {
                return COUPON_EXCHANGE;
            }
            if (Objects.equals(coupon.getCategory(), Coupon.CATEGORY_THRESHOLD)) {
                if (Objects.equals(coupon.getType(), Coupon.TYPE_THRESHOLD_REDUCTION)) {
                    return COUPON_THRESHOLD_REDUCTION;
                }
                if (Objects.equals(coupon.getType(), Coupon.TYPE_THRESHOLD)) {
                    return COUPON_THRESHOLD;
                }
                return NULL;
            }
            if (Objects.equals(coupon.getCategory(), Coupon.CATEGORY_DISCOUNT)) {
                if (Objects.equals(coupon.getType(), Coupon.CATEGORY_DISCOUNT)) {
                    return COUPON_DISCOUNT;
                }
                if (Objects.equals(coupon.getType(), Coupon.TYPE_THRESHOLD_REDUCTION)) {
                    return COUPON_DISCOUNT_REDUCTION;
                }
                return NULL;
            }
            return NULL;
        }

        public static DiscountType getDiscountType(Promotion promotion) {
            if (Objects.equals(promotion.getCategory(), Promotion.CATEGORY_THRESHOLD_LOOP)) {
                return PROMOTION_THRESHOLD_LOOP;
            }
            if (Objects.equals(promotion.getCategory(), Promotion.CATEGORY_GIFT)) {
                return PROMOTION_GIFT;
            }
            if (Objects.equals(promotion.getCategory(), Promotion.CATEGORY_THRESHOLD_GIFT)) {
                return PROMOTION_THRESHOLD_GIFT;
            }
            return NULL;
        }
    }
}

