/**
 * 
 */
package com.ptteng.sca.micro.mall.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.mall.model.StockIn;
import com.ptteng.micro.mall.service.StockInService;

import java.util.List;
import java.util.Map;

public class StockInSCAClient implements StockInService {

    private StockInService stockInService;

	public StockInService getStockInService() {
		return stockInService;
	}
	
	
	public void setStockInService(StockInService stockInService) {
		this.stockInService =stockInService;
	}
	
	
			   
		@Override
		public Long insert(StockIn stockIn)throws ServiceException, ServiceDaoException{
		
		return stockInService.insert(stockIn);
		          
		
		}	
		  
    	   
		@Override
		public List<StockIn> insertList(List<StockIn> stockInList)throws ServiceException, ServiceDaoException{
		
		return stockInService.insertList(stockInList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return stockInService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(StockIn stockIn)throws ServiceException, ServiceDaoException{
		
		return stockInService.update(stockIn);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<StockIn> stockInList)throws ServiceException, ServiceDaoException{
		
		return stockInService.updateList(stockInList);
		          
		
		}	
		  
    	   
		@Override
		public StockIn getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return stockInService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<StockIn> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return stockInService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockInIdsBySkuId(Long skuId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockInService.getStockInIdsBySkuId(skuId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockInIdsBySpuId(Long spuId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockInService.getStockInIdsBySpuId(spuId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockInIdsBySkuId(Long skuId)throws ServiceException, ServiceDaoException{
		
		return stockInService.countStockInIdsBySkuId(skuId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockInIdsBySpuId(Long spuId)throws ServiceException, ServiceDaoException{
		
		return stockInService.countStockInIdsBySpuId(spuId);
	
	
	}
	
		
	
		@Override
	public List<Long> getStockInIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockInService.getStockInIds(start, limit);
	}

	@Override
	public Integer countStockInIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockInService.countStockInIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockInService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockInService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   stockInService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.stockInService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Object getMapListByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.stockInService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


 
}

