/**
 * 
 */
package com.ptteng.sca.micro.mall.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.mall.model.StockInOrder;
import com.ptteng.micro.mall.service.StockInOrderService;

import java.util.List;
import java.util.Map;

public class StockInOrderSCAClient implements StockInOrderService {

    private StockInOrderService stockInOrderService;

	public StockInOrderService getStockInOrderService() {
		return stockInOrderService;
	}
	
	
	public void setStockInOrderService(StockInOrderService stockInOrderService) {
		this.stockInOrderService =stockInOrderService;
	}
	
	
			   
		@Override
		public Long insert(StockInOrder stockInOrder)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.insert(stockInOrder);
		          
		
		}	
		  
    	   
		@Override
		public List<StockInOrder> insertList(List<StockInOrder> stockInOrderList)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.insertList(stockInOrderList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(StockInOrder stockInOrder)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.update(stockInOrder);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<StockInOrder> stockInOrderList)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.updateList(stockInOrderList);
		          
		
		}	
		  
    	   
		@Override
		public StockInOrder getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<StockInOrder> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockInOrderIdsByMerchantIdAndStatus(Long merchantId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.getStockInOrderIdsByMerchantIdAndStatus(merchantId,status,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockInOrderIdsByMerchantId(Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.getStockInOrderIdsByMerchantId(merchantId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getStockInOrderIdByPurchaseNo(String purchaseNo)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.getStockInOrderIdByPurchaseNo(purchaseNo);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockInOrderIdsByMerchantIdAndStatus(Long merchantId,Integer status)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.countStockInOrderIdsByMerchantIdAndStatus(merchantId,status);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockInOrderIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException{
		
		return stockInOrderService.countStockInOrderIdsByMerchantId(merchantId);
	
	
	}
	
		
	
		@Override
	public List<Long> getStockInOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockInOrderService.getStockInOrderIds(start, limit);
	}

	@Override
	public Integer countStockInOrderIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockInOrderService.countStockInOrderIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockInOrderService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockInOrderService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   stockInOrderService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.stockInOrderService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Object getMapListByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.stockInOrderService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


 
}

