package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.StockOrderPrint;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface StockOrderPrintService extends BaseDaoService {

	



   		   
		
		public Long insert(StockOrderPrint stockOrderPrint)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockOrderPrint> insertList(List<StockOrderPrint> stockOrderPrintList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(StockOrderPrint stockOrderPrint)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<StockOrderPrint> stockOrderPrintList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public StockOrderPrint getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockOrderPrint> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockOrderPrintIdsByMerchantIdAndStatus(Long merchantId, Integer status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockOrderPrintIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockOrderPrintIdsByMerchantIdOrderByCreateAt(Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockOrderPrintIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockOrderPrintIdsByMerchantId(Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getStockOrderPrintIdByMerchantIdAndStockOrderIdAndOrderType(Long merchantId, Long stockOrderId, Integer orderType)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockOrderPrintIdsByMerchantIdOrderByCreateAt(Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getStockOrderPrintIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countStockOrderPrintIds() throws ServiceException, ServiceDaoException;
	

}

