package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.BaseClassifySpu;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface BaseClassifySpuService extends BaseDaoService {

	



   		   
		
		public Long insert(BaseClassifySpu baseClassifySpu)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<BaseClassifySpu> insertList(List<BaseClassifySpu> baseClassifySpuList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(BaseClassifySpu baseClassifySpu)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<BaseClassifySpu> baseClassifySpuList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public BaseClassifySpu getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<BaseClassifySpu> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countBaseClassifySpuIdsBySpuId(Long spuId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countBaseClassifySpuIdsByClassifyId(Long classifyId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countBaseClassifySpuIdsByClassifyIdAndMerchantId(Long classifyId, Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getBaseClassifySpuIdsBySpuId(Long spuId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getBaseClassifySpuIdsByClassifyId(Long classifyId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getBaseClassifySpuIdsByClassifyIdAndMerchantId(Long classifyId, Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getBaseClassifySpuIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countBaseClassifySpuIds() throws ServiceException, ServiceDaoException;
	

}

