package com.ptteng.micro.mall.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "stock_in")
public class StockIn implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 950881666327948288L;

    public static final Integer CLIENT_WX = 2;
    public static final Integer CLIENT_ADMIN = 1;
	/**
	 *  自动
	 * 
	 */
	public static final Integer ACTION_TYPE_SYS = 1;
    	
	/**
	 *  手动
	 * 
	 */
	public static final Integer ACTION_TYPE_MANUAL = 2;
    	
	/**
	 *  退货
	 * 
	 */
	public static final Integer ACTION_TYPE_REFUND = 3;
    	
   
   /**
   *  自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  品类id
   *
   */
    private  Long classifyId;
	
  
   /**
   *  商品品类
   *
   */
    private  String classifyDesc;
	
  
   /**
   *  商品id
   *
   */
    private  Long spuId;
	
  
   /**
   *  商品名称
   *
   */
    private  String spuTitle;
	
  
   /**
   *  入库量
   *
   */
    private  Integer amount;
	
  
   /**
   *  仓储库存
   *
   */
    private  Integer warehouseStock;
	
  
   /**
   *  备注
   *
   */
    private  String description;
	
  
   /**
   *  skuid
   *
   */
    private  Long skuId;
	
  
   /**
   *  进价
   *
   */
    private BigDecimal purchasePrice;
	
  
   /**
   *  sku名称
   *
   */
    private  String skuTitle;
	
  
   /**
   *  采购日期
   *
   */
    private  Long purchaseDate;
	
  
   /**
   *  供应商名称
   *
   */
    private  String supplierName;
	
  
   /**
   *  供应商id
   *
   */
    private  Long supplierId;
	
  
   /**
   *  操作类型
   *
   */
    private  Integer actionType;
	
  
   /**
   *  采购单号
   *
   */
    private  String purchaseNo;
	
  
   /**
   *  商户id
   *
   */
    private  Long merchantId;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新人
   *
   */
    private  Long updateBy;
	
    private  Integer client;


    private Integer numerator;

    private Integer denominator;

    private Integer packageNum;
    private BigDecimal totalPrice;
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "classify_id")
	public Long getClassifyId() {
		return classifyId;
	}
	
	
	public void setClassifyId(Long classifyId) {
		this.classifyId = classifyId;
	}
		 	@Column(name = "classify_desc")
	public String getClassifyDesc() {
		return classifyDesc;
	}
	
	
	public void setClassifyDesc(String classifyDesc) {
		this.classifyDesc = classifyDesc;
	}
		 	@Column(name = "spu_id")
	public Long getSpuId() {
		return spuId;
	}
	
	
	public void setSpuId(Long spuId) {
		this.spuId = spuId;
	}
		 	@Column(name = "spu_title")
	public String getSpuTitle() {
		return spuTitle;
	}
	
	
	public void setSpuTitle(String spuTitle) {
		this.spuTitle = spuTitle;
	}
		 	@Column(name = "amount")
	public Integer getAmount() {
		return amount;
	}
	
	
	public void setAmount(Integer amount) {
		this.amount = amount;
	}
		 	@Column(name = "warehouse_stock")
	public Integer getWarehouseStock() {
		return warehouseStock;
	}
	
	
	public void setWarehouseStock(Integer warehouseStock) {
		this.warehouseStock = warehouseStock;
	}
		 	@Column(name = "description")
	public String getDescription() {
		return description;
	}
	
	
	public void setDescription(String description) {
		this.description = description;
	}
		 	@Column(name = "sku_id")
	public Long getSkuId() {
		return skuId;
	}
	
	
	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}
		 	@Column(name = "purchase_price")
	public BigDecimal getPurchasePrice() {
		return purchasePrice;
	}
	
	
	public void setPurchasePrice(BigDecimal purchasePrice) {
		this.purchasePrice = purchasePrice;
	}
		 	@Column(name = "sku_title")
	public String getSkuTitle() {
		return skuTitle;
	}
	
	
	public void setSkuTitle(String skuTitle) {
		this.skuTitle = skuTitle;
	}
		 	@Column(name = "purchase_date")
	public Long getPurchaseDate() {
		return purchaseDate;
	}
	
	
	public void setPurchaseDate(Long purchaseDate) {
		this.purchaseDate = purchaseDate;
	}
		 	@Column(name = "supplier_name")
	public String getSupplierName() {
		return supplierName;
	}
	
	
	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}
		 	@Column(name = "supplier_id")
	public Long getSupplierId() {
		return supplierId;
	}
	
	
	public void setSupplierId(Long supplierId) {
		this.supplierId = supplierId;
	}
		 	@Column(name = "action_type")
	public Integer getActionType() {
		return actionType;
	}
	
	
	public void setActionType(Integer actionType) {
		this.actionType = actionType;
	}
		 	@Column(name = "purchase_no")
	public String getPurchaseNo() {
		return purchaseNo;
	}
	
	
	public void setPurchaseNo(String purchaseNo) {
		this.purchaseNo = purchaseNo;
	}
		 	@Column(name = "merchant_id")
	public Long getMerchantId() {
		return merchantId;
	}
	
	
	public void setMerchantId(Long merchantId) {
		this.merchantId = merchantId;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
    @Column(name = "client")
    public Integer getClient() {
        return client;
    }
    @Column(name = "numerator")
    public Integer getNumerator() {
        return numerator;
    }

    public void setNumerator(Integer numerator) {
        this.numerator = numerator;
    }
    @Column(name = "denominator")
    public Integer getDenominator() {
        return denominator;
    }

    public void setDenominator(Integer denominator) {
        this.denominator = denominator;
    }
    @Column(name = "package_num")
    public Integer getPackageNum() {
        return packageNum;
    }

    public void setPackageNum(Integer packageNum) {
        this.packageNum = packageNum;
    }
    @Column(name = "total_price")
    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }
    public void setClient(Integer client) {
        this.client = client;
    }
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

