/**
 *
 */
package com.ptteng.sca.micro.mall.client;

import java.util.List;
import java.util.Map;

import com.ptteng.micro.mall.model.Requirement;
import com.ptteng.micro.mall.service.RequirementService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class RequirementSCAClient implements RequirementService {

    private RequirementService requirementService;

    public RequirementService getRequirementService() {
        return requirementService;
    }


    public void setRequirementService(RequirementService requirementService) {
        this.requirementService = requirementService;
    }


    @Override
    public Long insert(Requirement requirement) throws ServiceException, ServiceDaoException {

        return requirementService.insert(requirement);


    }


    @Override
    public List<Requirement> insertList(List<Requirement> requirementList) throws ServiceException, ServiceDaoException {

        return requirementService.insertList(requirementList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return requirementService.delete(id);


    }


    @Override
    public boolean update(Requirement requirement) throws ServiceException, ServiceDaoException {

        return requirementService.update(requirement);


    }


    @Override
    public boolean updateList(List<Requirement> requirementList) throws ServiceException, ServiceDaoException {

        return requirementService.updateList(requirementList);


    }


    @Override
    public Requirement getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return requirementService.getObjectById(id);


    }


    @Override
    public List<Requirement> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return requirementService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getRequirementIdsByUserIdAndMerchantId(Long userId, Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return requirementService.getRequirementIdsByUserIdAndMerchantId(userId, merchantId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countRequirementIdsByUserIdAndMerchantId(Long userId, Long merchantId) throws ServiceException, ServiceDaoException {

        return requirementService.countRequirementIdsByUserIdAndMerchantId(userId, merchantId);


    }


    @Override
    public List<Long> getRequirementIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return requirementService.getRequirementIds(start, limit);
    }

    @Override
    public Integer countRequirementIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return requirementService.countRequirementIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return requirementService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return requirementService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        requirementService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.requirementService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.requirementService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

