/**
 *
 */
package com.ptteng.sca.micro.mall.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.mall.model.Brand;
import com.ptteng.micro.mall.service.BrandService;

import java.util.List;
import java.util.Map;

public class BrandSCAClient implements BrandService {

    private BrandService brandService;

    public BrandService getBrandService() {
        return brandService;
    }


    public void setBrandService(BrandService brandService) {
        this.brandService = brandService;
    }


    @Override
    public Long insert(Brand brand) throws ServiceException, ServiceDaoException {

        return brandService.insert(brand);


    }


    @Override
    public List<Brand> insertList(List<Brand> brandList) throws ServiceException, ServiceDaoException {

        return brandService.insertList(brandList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return brandService.delete(id);


    }


    @Override
    public boolean update(Brand brand) throws ServiceException, ServiceDaoException {

        return brandService.update(brand);


    }


    @Override
    public boolean updateList(List<Brand> brandList) throws ServiceException, ServiceDaoException {

        return brandService.updateList(brandList);


    }


    @Override
    public Brand getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return brandService.getObjectById(id);


    }


    @Override
    public List<Brand> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return brandService.getObjectsByIds(ids);


    }


    @Override
    public List<Long> getBrandIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return brandService.getBrandIds(start, limit);
    }

    @Override
    public List<Long> getBrandIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return brandService.getBrandIdsByMerchantIdAndStatus(merchantId,status,start, limit);
    }

    @Override
    public Integer countBrandIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return brandService.countBrandIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return brandService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return brandService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        brandService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.brandService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.brandService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

