package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.StockIn;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface StockInService extends BaseDaoService {

	



   		   
		
		public Long insert(StockIn stockIn)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockIn> insertList(List<StockIn> stockInList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(StockIn stockIn)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<StockIn> stockInList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public StockIn getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockIn> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockInIdsBySkuId(Long skuId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockInIdsBySpuId(Long spuId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockInIdsBySkuId(Long skuId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockInIdsBySpuId(Long spuId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getStockInIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countStockInIds() throws ServiceException, ServiceDaoException;
	

}

