package com.ptteng.micro.mall.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "worker_order_relation")
public class WorkerOrderRelation implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 638008031308165120L;


    /**
     * 接单
     */
    public static final Integer TYPE_ACCEPT = 10;

    /**
     * 拒绝
     */
    public static final Integer TYPE_REFUSE = 20;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 商户Id
     */
    private Long merchantId;


    private Long orderId;
    /**
     * 闪工Id
     */
    private Long workerId;


    /**
     * 状态
     */
    private Integer status;
    /*
    * 是否需要抢单
    * */
    private Integer needGrab;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }


    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Column(name = "order_id")
    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    @Column(name = "worker_id")
    public Long getWorkerId() {
        return workerId;
    }


    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }


    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }
    @Column(name = "need_grab")
    public Integer getNeedGrab() {
        return needGrab;
    }

    public void setNeedGrab(Integer needGrab) {
        this.needGrab = needGrab;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

