/**
 * 
 */
package com.ptteng.sca.micro.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.common.model.SubscribeMsg;
import com.ptteng.micro.common.service.SubscribeMsgService;

import java.util.List;
import java.util.Map;

public class SubscribeMsgSCAClient implements SubscribeMsgService {

    private SubscribeMsgService subscribeMsgService;

	public SubscribeMsgService getSubscribeMsgService() {
		return subscribeMsgService;
	}
	
	
	public void setSubscribeMsgService(SubscribeMsgService subscribeMsgService) {
		this.subscribeMsgService =subscribeMsgService;
	}
	
	
			   
		@Override
		public Long insert(SubscribeMsg subscribeMsg)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.insert(subscribeMsg);
		          
		
		}	
		  
    	   
		@Override
		public List<SubscribeMsg> insertList(List<SubscribeMsg> subscribeMsgList)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.insertList(subscribeMsgList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(SubscribeMsg subscribeMsg)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.update(subscribeMsg);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<SubscribeMsg> subscribeMsgList)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.updateList(subscribeMsgList);
		          
		
		}	
		  
    	   
		@Override
		public SubscribeMsg getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<SubscribeMsg> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSubscribeMsgIdsByUserIdAndMerchantId(Long userId,Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.getSubscribeMsgIdsByUserIdAndMerchantId(userId,merchantId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getSubscribeMsgIdByUserIdAndMerchantIdAndCategoryAndType(Long userId,Long merchantId,Integer category,Integer type)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.getSubscribeMsgIdByUserIdAndMerchantIdAndCategoryAndType(userId,merchantId,category,type);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSubscribeMsgIdsByUserIdAndMerchantIdAndCategory(Long userId,Long merchantId,Integer category,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.getSubscribeMsgIdsByUserIdAndMerchantIdAndCategory(userId,merchantId,category,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getSubscribeMsgIdByUserIdAndTemplateId(Long userId,String templateId)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.getSubscribeMsgIdByUserIdAndTemplateId(userId,templateId);
	
	
	}

    @Override
    public Long getSubscribeMsgIdByUserIdAndAppIdAndTemplateId(Long userId, String appId,String templateId) throws ServiceException, ServiceDaoException {
        return subscribeMsgService.getSubscribeMsgIdByUserIdAndAppIdAndTemplateId(userId,appId,templateId);
    }

    @Override
    public Long getSubscribeMsgIdByUserIdAndAppIdAndCategoryAndType(Long userId, String appId, Integer category, Integer type) throws ServiceException, ServiceDaoException {
        return subscribeMsgService.getSubscribeMsgIdByUserIdAndAppIdAndCategoryAndType(userId, appId, category, type);
    }


    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSubscribeMsgIdsByUserIdAndMerchantId(Long userId,Long merchantId)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.countSubscribeMsgIdsByUserIdAndMerchantId(userId,merchantId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSubscribeMsgIdsByUserIdAndMerchantIdAndCategory(Long userId,Long merchantId,Integer category)throws ServiceException, ServiceDaoException{
		
		return subscribeMsgService.countSubscribeMsgIdsByUserIdAndMerchantIdAndCategory(userId,merchantId,category);
	
	
	}
	
		
	
		@Override
	public List<Long> getSubscribeMsgIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return subscribeMsgService.getSubscribeMsgIds(start, limit);
	}

	@Override
	public Integer countSubscribeMsgIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return subscribeMsgService.countSubscribeMsgIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return subscribeMsgService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return subscribeMsgService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   subscribeMsgService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.subscribeMsgService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}

	@Override
	public Object getMapListByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
		return null;
	}

}

