package com.ptteng.micro.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "merchant")
public class Merchant implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4278977928020689920L;

    public static final Integer USE = 10;

    public static final Integer EXPIRE = 20;

    public static final Integer ALL = 0;

    public static final int MERCHANT_TYPE_MALL = 2;
    public static final int MERCHANT_TYPE_DEFAULT = 1;

    public static final int WARN_STOCK_DEFAULT = 10;
    public static final Integer XIAOETECH_DISBILE = 0;
    public static final Integer XIAOETECH_ENBILE = 1;
    public static final Integer STATUS_DISABLE = 1;
    public static final Integer STATUS_ENABLE = 0;
    /**
     * 主键,自增长ID
     */
    private Long id;

    private String name;
    /**
     * 用户ID
     */
    private Long uid;


    /**
     * 用户状态
     */
    private Integer status;


    /**
     * 微信appid
     */
    private String appId;
    private String pcAppId;


    /**
     * 微信appsecret
     */
    private String appSecret;
    private String pcAppSecret;
    /**
     * 微信appid
     */
    private String wxApplicationAppId;

    /**
     * 公众号appId
     */
    private String wxOfficialAccountAppId;
    /**
     * 公众号appSecret
     */
    private String wxOfficialAccountSecret;


    /**
     * 微信appsecret
     */
    private String wxApplicationSecret;


    /**
     * 购买次数
     */
    private Integer purchaseTime;


    /**
     * 总金额
     */
    private BigDecimal totalAmount;

    /**
     * 行业模板ID
     */
    private Long industryTemplateId;


    /**
     * 商户号起始时间
     */
    private Long startAt;


    /**
     * 商户号到期时间
     */
    private Long endAt;

    /**
     * 分享文案
     */
    private String shareContents;

    /**
     * 小程序logo
     */
    private String logo;

    /**
     * PC端首页模板ID
     */
    private Long homepageTemplateId;

    /**
     * 商户PC域名
     */
    private String domainName;
    /**
     * 后台域名
     */
    private String adminDomain;

    private String address;

    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 创建者
     */
    private Long createBy;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 更新者
     */
    private Long updateBy;

    /**
     * 公司名称
     */
    private String companyName;
    /**
     * 公司简称
     */
    private String companyAbbreviation;
    /**
     * 法人手机号
     */
    private String legalPersonPhone;
    /**
     * 法人邮箱
     */
    private String legalPersonMail;
    /**
     * 扩展字符串(存储身份证照片,营业执照,开户许可证等)
     */
    private String extend;
    /**
     * 商户类型
     */
    private Integer type;
    /**
     * 微信支付商户号
     */
    private String wxMchId;
    /**
     * 微信支付商户key
     */
    private String wxMchKey;
    /**
     * 微信服务商分账费率
     */
    private BigDecimal wxRate;
    private BigDecimal aliTradeSettleRate;
    /**
     * 库存预警值
     */
    private Integer warnStock;

    /*
     * 支付宝应用Id
     * */
    private String aliAppId;
    /*
     * 支付宝应用私钥
     * */
    private String privateKey;
    /*
     *  支付宝平台公钥
     * */
    private String aliPublicKey;
    /*
     * 支付宝主账号(商户)pid
     * */
    private String aliPid;

    /*
     * 纬度
     * */
    private BigDecimal geolat;
    /*
     * 经度
     * */
    private BigDecimal geolng;

    private String config;
    /*
     * 小鹅通配置
     * */
    private Integer xiaoetech=XIAOETECH_DISBILE;
    private String xiaoetechAppId;
    private String xiaoetechClientId;
    private String xiaoetechClientSecret;
    private String xiaoetechPushKey;
    private String xiaoetechPushToken;
    private String IdCardVerificationSecretId;
    private String IdCardVerificationSecretKey;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "app_id")
    public String getAppId() {
        return appId;
    }


    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Column(name = "app_secret")
    public String getAppSecret() {
        return appSecret;
    }


    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Column(name = "purchase_time")
    public Integer getPurchaseTime() {
        return purchaseTime;
    }


    public void setPurchaseTime(Integer purchaseTime) {
        this.purchaseTime = purchaseTime;
    }

    @Column(name = "total_amount")
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }


    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Column(name = "start_at")
    public Long getStartAt() {
        return startAt;
    }


    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    @Column(name = "end_at")
    public Long getEndAt() {
        return endAt;
    }


    public void setEndAt(Long endAt) {
        this.endAt = endAt;
    }

    @Column(name = "logo")
    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }


    @Column(name = "homepage_template_id")
    public Long getHomepageTemplateId() {
        return homepageTemplateId;
    }

    public void setHomepageTemplateId(Long homepageTemplateId) {
        this.homepageTemplateId = homepageTemplateId;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "company_name")
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Column(name = "company_abbreviation")
    public String getCompanyAbbreviation() {
        return companyAbbreviation;
    }

    public void setCompanyAbbreviation(String companyAbbreviation) {
        this.companyAbbreviation = companyAbbreviation;
    }

    @Column(name = "legal_person_phone")
    public String getLegalPersonPhone() {
        return legalPersonPhone;
    }

    public void setLegalPersonPhone(String legalPersonPhone) {
        this.legalPersonPhone = legalPersonPhone;
    }

    @Column(name = "legal_person_mail")
    public String getLegalPersonMail() {
        return legalPersonMail;
    }

    public void setLegalPersonMail(String legalPersonMail) {
        this.legalPersonMail = legalPersonMail;
    }


    @Column(name = "domain_name")
    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Column(name = "extend")
    public String getExtend() {
        return extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    @Column(name = "share_contents")
    public String getShareContents() {
        return shareContents;
    }

    public void setShareContents(String shareContents) {
        this.shareContents = shareContents;
    }

    @Column(name = "industry_template_id")
    public Long getIndustryTemplateId() {
        return industryTemplateId;
    }

    public void setIndustryTemplateId(Long industryTemplateId) {
        this.industryTemplateId = industryTemplateId;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "wx_mch_id")
    public String getWxMchId() {
        return wxMchId;
    }

    public void setWxMchId(String wxMchId) {
        this.wxMchId = wxMchId;
    }

    @Column(name = "wx_mch_key")
    public String getWxMchKey() {
        return wxMchKey;
    }

    public void setWxMchKey(String wxMchKey) {
        this.wxMchKey = wxMchKey;
    }

    @Column(name = "wx_rate")
    public BigDecimal getWxRate() {
        return wxRate;
    }

    public void setWxRate(BigDecimal wxRate) {
        this.wxRate = wxRate;
    }

    @Column(name = "warn_stock")
    public Integer getWarnStock() {
        return warnStock;
    }

    public void setWarnStock(Integer warnStock) {
        this.warnStock = warnStock;
    }

    @Column(name = "address")
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "ali_app_id")
    public String getAliAppId() {
        return aliAppId;
    }

    public void setAliAppId(String aliAppId) {
        this.aliAppId = aliAppId;
    }

    @Column(name = "private_key")
    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Column(name = "ali_public_key")
    public String getAliPublicKey() {
        return aliPublicKey;
    }

    public void setAliPublicKey(String aliPublicKey) {
        this.aliPublicKey = aliPublicKey;
    }

    @Column(name = "ali_pid")
    public String getAliPid() {
        return aliPid;
    }

    public void setAliPid(String aliPid) {
        this.aliPid = aliPid;
    }

    @Column(name = "ali_trade_settle_rate")
    public BigDecimal getAliTradeSettleRate() {
        return aliTradeSettleRate;
    }

    public void setAliTradeSettleRate(BigDecimal aliTradeSettleRate) {
        this.aliTradeSettleRate = aliTradeSettleRate;
    }

    public BigDecimal getGeolat() {
        return geolat;
    }

    @Column(name = "geolat")
    public void setGeolat(BigDecimal geolat) {
        this.geolat = geolat;
    }

    public BigDecimal getGeolng() {
        return geolng;
    }

    @Column(name = "geolng")
    public void setGeolng(BigDecimal geolng) {
        this.geolng = geolng;
    }

    @Column(name = "wx_application_app_id")
    public String getWxApplicationAppId() {
        return wxApplicationAppId;
    }

    public void setWxApplicationAppId(String wxApplicationAppId) {
        this.wxApplicationAppId = wxApplicationAppId;
    }

    @Column(name = "wx_application_secret")
    public String getWxApplicationSecret() {
        return wxApplicationSecret;
    }

    public void setWxApplicationSecret(String wxApplicationSecret) {
        this.wxApplicationSecret = wxApplicationSecret;
    }

    @Column(name = "wx_official_account_app_id")
    public String getWxOfficialAccountAppId() {
        return wxOfficialAccountAppId;
    }

    public void setWxOfficialAccountAppId(String wxOfficialAccountAppId) {
        this.wxOfficialAccountAppId = wxOfficialAccountAppId;
    }

    @Column(name = "wx_official_account_app_secret")
    public String getWxOfficialAccountSecret() {
        return wxOfficialAccountSecret;
    }

    public void setWxOfficialAccountSecret(String wxOfficialAccountSecret) {
        this.wxOfficialAccountSecret = wxOfficialAccountSecret;
    }

    @Column(name = "config")
    public String getConfig() {
        return config;
    }

    public void setConfig(String config) {
        this.config = config;
    }
    @Column(name = "xiaoetech")
    public Integer getXiaoetech() {
        return xiaoetech;
    }

    public void setXiaoetech(Integer xiaoetech) {
        this.xiaoetech = xiaoetech;
    }
    @Column(name = "xiaoetech_appid")
    public String getXiaoetechAppId() {
        return xiaoetechAppId;
    }

    public void setXiaoetechAppId(String xiaoetechAppId) {
        this.xiaoetechAppId = xiaoetechAppId;
    }
    @Column(name = "xiaoetech_client_id")
    public String getXiaoetechClientId() {
        return xiaoetechClientId;
    }

    public void setXiaoetechClientId(String xiaoetechClientId) {
        this.xiaoetechClientId = xiaoetechClientId;
    }
    @Column(name = "xiaoetech_client_secret")
    public String getXiaoetechClientSecret() {
        return xiaoetechClientSecret;
    }

    public void setXiaoetechClientSecret(String xiaoetechClientSecret) {
        this.xiaoetechClientSecret = xiaoetechClientSecret;
    }
    @Column(name = "xiaoetech_push_key")
    public String getXiaoetechPushKey() {
        return xiaoetechPushKey;
    }

    public void setXiaoetechPushKey(String xiaoetechPushKey) {
        this.xiaoetechPushKey = xiaoetechPushKey;
    }
    @Column(name = "xiaoetech_push_token")
    public String getXiaoetechPushToken() {
        return xiaoetechPushToken;
    }

    public void setXiaoetechPushToken(String xiaoetechPushToken) {
        this.xiaoetechPushToken = xiaoetechPushToken;
    }
    @Column(name = "admin_domain")
    public String getAdminDomain() {
        return adminDomain;
    }

    public void setAdminDomain(String adminDomain) {
        this.adminDomain = adminDomain;
    }

    @Column(name = "pc_app_id")
    public String getPcAppId() {
        return pcAppId;
    }

    public void setPcAppId(String pcAppId) {
        this.pcAppId = pcAppId;
    }

    @Column(name = "pc_app_secret")
    public String getPcAppSecret() {
        return pcAppSecret;
    }

    public void setPcAppSecret(String pcAppSecret) {
        this.pcAppSecret = pcAppSecret;
    }
    @Column(name = "id_card_verification_secret_id")
    public String getIdCardVerificationSecretId() {
        return IdCardVerificationSecretId;
    }

    public void setIdCardVerificationSecretId(String idCardVerificationSecretId) {
        IdCardVerificationSecretId = idCardVerificationSecretId;
    }
    @Column(name = "id_card_verification_secret_key")
    public String getIdCardVerificationSecretKey() {
        return IdCardVerificationSecretKey;
    }

    public void setIdCardVerificationSecretKey(String idCardVerificationSecretKey) {
        IdCardVerificationSecretKey = idCardVerificationSecretKey;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

