package com.ptteng.micro.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "gcomponent_ru")
public class GcomponentPt implements Serializable {




  /**
   * 全局组件：普通分类解析
   */
//  public static final int GLOBAL_COMMON_COMPONENT = 9;

  /**
   * 全局组件：不需要解析组件
   */
  public static final int GLOBAL_NO_NEED_PARSE_COMPONENT = 7;

  /**
   * 全局组件：分类列表解析
   */
  public static final int GLOBAL_CLASSIFY_COMPONENT = 11;

  /**
   * pc端默认level
   */
  public static final int DEFAULT_GLOBAL_COMPONENT_LEVEL = -1;
    private static final long serialVersionUID = 35147165078667817L;


    /**
   * 自增长ID
   */
  private Long id;


  /**
   * 商户ID
   */
  private Long merchantId;


  /**
   * 组件类型
   */
  private Integer type;


  /**
   * 名称
   */
  private String name;


  /**
   *
   */
  private String value;


  /**
   *
   */
  private Integer level;


  /**
   * 创建人ID
   */
  private Long createBy;


  /**
   * 更新人ID
   */
  private Long updateBy;


  /**
   * 数据更新时间
   */
  private Long updateAt;


  /**
   * 创建时间
   */
  private Long createAt;


  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.AUTO)
  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  @Column(name = "merchant_id")
  public Long getMerchantId() {
    return merchantId;
  }


  public void setMerchantId(Long merchantId) {
    this.merchantId = merchantId;
  }

  @Column(name = "type")
  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }

  @Column(name = "name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }




  @Column(name = "value")
  public String getValue() {
    return value;
  }


  public void setValue(String value) {
    this.value = value;
  }

  @Column(name = "level")
  public Integer getLevel() {
    return level;
  }


  public void setLevel(Integer level) {
    this.level = level;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }


  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this,
            ToStringStyle.MULTI_LINE_STYLE);
  }

}

