package com.ptteng.micro.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "doc")
public class Doc implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 8502160857272444928L;


    /**
     * 未审核
     */
    public static final Integer STATUS_NOT_REVIEW = 0;

    /**
     * 通过
     */
    public static final Integer STATUS_PASS = 1;

    /**
     * 驳回
     */
    public static final Integer STATUS_REJECT = 2;

    /**
     * 屏蔽
     */
    public static final Integer STATUS_DISABLE = 3;

    /**
     * 不推荐
     */
    public static final Integer RECOMMEND_STATUS_NOT = 0;

    /**
     * 推荐中
     */
    public static final Integer RECOMMEND_STATUS_DOING = 1;

    /**
     * 推荐完成
     */
    public static final Integer RECOMMEND_STATUS_YES = 2;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 商户ID
     */
    private Long merchantId;


    /**
     * 编号
     */
    private String serialNumber;


    /**
     * 出版人
     */
    private String publisher;


    /**
     * 标题
     */
    private String title;


    /**
     * 介绍
     */
    private String intro;


    /**
     * 内容
     */
    private String content;


    /**
     * 状态
     */
    private Integer status;


    /**
     * 审核时间
     */
    private Long reviewAt;


    /**
     * 审核人
     */
    private Long reviewBy;


    /**
     * 审核意见
     */
    private String reviewDesc;


    /**
     * 作者信息
     */
    private String authorInfo;


    /**
     * 联系信息
     */
    private String phone;


    /**
     * 联系信息
     */
    private String address;


    /**
     * 文档信息
     */
    private String docInfo;


    /**
     * 单位
     */
    private String unit;


    /**
     * 推荐人
     */
    private String referrer;


    /**
     * 投票数
     */
    private Integer voteCount;


    /**
     * 点赞数
     */
    private Integer favorCount;


    /**
     * 收藏数
     */
    private Integer collectCount;
    /**
     * 评论数
     */
    private Integer commentCount;


    /**
     * 推荐状态
     */
    private Integer recommendStatus;


    /**
     * 分数
     */
    private Float score;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }


    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Column(name = "serial_number")
    public String getSerialNumber() {
        return serialNumber;
    }


    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Column(name = "publisher")
    public String getPublisher() {
        return publisher;
    }


    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "intro")
    public String getIntro() {
        return intro;
    }


    public void setIntro(String intro) {
        this.intro = intro;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "review_at")
    public Long getReviewAt() {
        return reviewAt;
    }


    public void setReviewAt(Long reviewAt) {
        this.reviewAt = reviewAt;
    }

    @Column(name = "review_by")
    public Long getReviewBy() {
        return reviewBy;
    }


    public void setReviewBy(Long reviewBy) {
        this.reviewBy = reviewBy;
    }

    @Column(name = "review_desc")
    public String getReviewDesc() {
        return reviewDesc;
    }


    public void setReviewDesc(String reviewDesc) {
        this.reviewDesc = reviewDesc;
    }

    @Column(name = "author_info")
    public String getAuthorInfo() {
        return authorInfo;
    }


    public void setAuthorInfo(String authorInfo) {
        this.authorInfo = authorInfo;
    }

    @Column(name = "phone")
    public String getPhone() {
        return phone;
    }


    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Column(name = "address")
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "doc_info")
    public String getDocInfo() {
        return docInfo;
    }


    public void setDocInfo(String docInfo) {
        this.docInfo = docInfo;
    }

    @Column(name = "unit ")
    public String getUnit() {
        return unit;
    }


    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Column(name = "referrer ")
    public String getReferrer() {
        return referrer;
    }


    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    @Column(name = "vote_count")
    public Integer getVoteCount() {
        return voteCount;
    }


    public void setVoteCount(Integer voteCount) {
        this.voteCount = voteCount;
    }

    @Column(name = "favor_count")
    public Integer getFavorCount() {
        return favorCount;
    }


    public void setFavorCount(Integer favorCount) {
        this.favorCount = favorCount;
    }

    @Column(name = "collect_count")
    public Integer getCollectCount() {
        return collectCount;
    }


    public void setCollectCount(Integer collectCount) {
        this.collectCount = collectCount;
    }

    @Column(name = "comment_count")
    public Integer getCommentCount() {
        return commentCount;
    }

    public void setCommentCount(Integer commentCount) {
        this.commentCount = commentCount;
    }

    @Column(name = "recommend_status")
    public Integer getRecommendStatus() {
        return recommendStatus;
    }


    public void setRecommendStatus(Integer recommendStatus) {
        this.recommendStatus = recommendStatus;
    }

    @Column(name = "score")
    public Float getScore() {
        return score;
    }


    public void setScore(Float score) {
        this.score = score;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

