package com.ptteng.micro.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "industry_template")
public class IndustryTemplate implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = 622289292367346688L;

  /**
   * 上架状态
   */
  public static final Integer STATUS_ON = 1;
  /**
   * 下架状态
   */
  public static final Integer STATUS_OFF = 0;

  /**
   * 自增长ID
   */
  private Long id;


  /**
   * 行业名称
   */
  private String name;


  /**
   * 菜单数组json
   */
  private String menuJson;

  /**
   * 上下架状态
   * 约定
   *
   * 1=上架
   *
   * 0=下架
   */
  private Integer status;

  /**
   * 根分类
   */
  private Long rootClassify;

  /**
   * 创建时间
   */
  private Long createAt;


  /**
   * 更新时间
   */
  private Long updateAt;


  /**
   * 创建人
   */
  private Long createBy;


  /**
   * 更新人
   */
  private Long updateBy;


  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  @Column(name = "name")
  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  @Column(name = "menu_json")
  public String getMenuJson() {
    return menuJson;
  }


  public void setMenuJson(String menuJson) {
    this.menuJson = menuJson;
  }

  @Column(name = "status")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @Column(name = "root_classify")
  public Long getRootClassify() {
    return rootClassify;
  }

  public void setRootClassify(Long rootClassify) {
    this.rootClassify = rootClassify;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }


  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this,
            ToStringStyle.MULTI_LINE_STYLE);
  }

}

