package com.ptteng.keeper.home.interceptor;

import com.gemantic.common.util.StringUtil;
import com.ptteng.keeper.common.model.Version;
import com.ptteng.keeper.common.service.VersionService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VersionInterceptor extends HandlerInterceptorAdapter {

    private static final Log log = LogFactory.getLog("versionInterceptor");

    @Autowired
    private VersionService versionService;

    private static final String PARAM_VERSION = "version";

    private static final String PARAM_OS = "os";

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {

        try {
            String version = request.getParameter(PARAM_VERSION);
            String os = request.getParameter(PARAM_OS);
            if (StringUtil.isEmpty(version)) {
                version = request.getHeader(PARAM_VERSION);
            }
            if (StringUtil.isEmpty(os)) {
                os = request.getHeader(PARAM_OS);
            }
            log.info("version interceptor version is: " + version);
            log.info("version interceptor os is: " + os);
            if (StringUtil.isEmpty(os)) {
                log.info("arg os is empty and need force updating");
                return versionUpdate(response);
            } else if (Version.OS_WEB.equals(os)) {
                log.info("arg os is empty and need force updating");
                return true;
            } else {
                log.info("android and ios");
            }

            if (StringUtil.isEmpty(version)) {
                log.info("arg version is empty need force updating");
                return versionUpdate(response);
            }

            List<Long> ids = versionService.getVersionIdsByOs(os, 0, Integer.MAX_VALUE);
            log.info("all " + os + " version ids list   is  " + ids);
            List<Version> allVersionList = versionService.getObjectsByIds(ids);
            Collections.sort(allVersionList);
            List<Version> versionList = new ArrayList<>();
            for (Version systemVersion : allVersionList) {
                switch (systemVersion.compareCode(systemVersion.getVersionCode(), version)) {
                    case 1:
                        versionList.add(systemVersion);
                        if (systemVersion.getIsForceUpdate()) {
                            log.info("need force updating");
                            return versionUpdate(response);
                        } else {
                            log.info("version : " + systemVersion.getVersionCode() + " is a new version but not need tu force updating");
                        }
                        break;
                    default:
                        break;
                }
            }
            log.info("new version list is" + versionList);
            if (CollectionUtils.isEmpty(versionList)) {
                log.info("version is new and don't need force updating");
                return true;
            } else {
                log.info("version is not new but don't need force updating");
                return true;
            }

        } catch (Throwable t) {
            log.error(t.getMessage(), t);
            return false;
        }
    }

    /**
     * 强制更新版本
     *
     * @param response
     * @return
     * @throws IOException
     */
    private boolean versionUpdate(HttpServletResponse response) throws IOException {

        log.info("force to update version begin...");
        response.sendRedirect("/a/force/update/version");
        return false;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {

        log.info("p =========================================== ");
    }

}
