package com.ptteng.keeper.home.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    public static Map<String, Object> getApplyingRecord(Long uid, Integer status,Long createAtStart,Long createAtEnd) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("applying_record");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("create_by", uid);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("level", status);
        }
        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            params.put("create_at & >=", createAtStart);
        }
        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            params.put("create_at & <=", createAtEnd);
        }

        params.put("@query", "id");
        params.put("@order", "create_at desc");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }
    public static Map<String, Object> getSumAmountByUidAndLevel(Long uid, Integer level) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("income_record");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("level", level);
        }

        params.put("@query", "sum(amount),create_by");
        params.put("@group", "create_by");
        params.put("@order", "id desc");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getApplyRecordByMobileAndIdCardAndProductId(String mobile, String idCard, Long productId, Long start, Long end, boolean count) {

        Map<String, Object> map = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(mobile)) {

            map.put("mobile", "'" + mobile + "'");

        }

        if (DataUtils.isNotNullOrEmpty(idCard)) {

            map.put("id_card", "'" + idCard + "'");

        }

        if (DataUtils.isNotNullOrEmpty(productId)) {

            map.put("product_id", productId);

        }

        if (DataUtils.isNotNullOrEmpty(start)) {

            map.put("create_at & >=", start);

        }
        if (DataUtils.isNotNullOrEmpty(end)) {

            map.put("create_at & <=", end);

        }

        if (count) {

            map.put("@query", "count(id)");

        } else {

            map.put("@order", "create_at desc");

            map.put("@query", "id");

        }

        map.put("@table", "applying_record");

        return map;

    }

    //用户列表
    public static Map<String, Object> getUserList(String mobile, Long startAt, Long endAt, Integer status, boolean count) {

        Map<String, Object> map = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(mobile)) {

            map.put("mobile & like ", "'%" + mobile + "%'");

        }

        if (DataUtils.isNotNullOrEmpty(startAt)) {

            map.put("create_at & >= ", startAt);

        }

        if (DataUtils.isNotNullOrEmpty(endAt)) {

            map.put("create_at &  <= ", endAt);

        }

        if (DataUtils.isNotNullOrEmpty(status)) {

            map.put("status", status);

        }


        if (count) {

            map.put("@query", "count(id)");

        } else {

            map.put("@order", "create_at desc");

            map.put("@query", "id");

        }

        map.put("@table", "user");

        return map;

    }

    public static Map<String, Object> getContentsQueryListParam(Integer[] type,
                                                                Integer status,
                                                                String title,
                                                                Long createBy,
                                                                Long createStartAt,
                                                                Long createEndAt,
                                                                Long publishStartAt,
                                                                Long publishEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(type)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (type != null) {
                for (Integer t : type) {
                    if (t != null) {
                        sb.append(t.toString());
                        sb.append(",");
                        i++;
                    }
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("type & in ", "(" + sb.toString() + ")");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title", "'" + title + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put("create_by", createBy);
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishStartAt)) {
            params.put("publish_at & >=", publishStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishEndAt)) {
            params.put("publish_at & <=", publishEndAt);
        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "contents ");

        return params;
    }

    public static Map<String, Object> getArticleListParam(String title, String url, String content, Integer status, Integer type, Integer bannerType) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("article");

        if (DataUtils.isNotNullOrEmpty(type)) {

            params.put(" article.type", type);
        } else {
            params.put(" (article.type ", " 1 or type = 2)");
        }
        if (DataUtils.isNotNullOrEmpty(bannerType)) {

            params.put(" article.banner_type", bannerType);
        }
        if (DataUtils.isNotNullOrEmpty(content)) {

            params.put(" article.content & like", " '%" + content + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(title)) {

            params.put(" article.title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(url)) {

            params.put(" article.url & like", " '%" + url + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {

            params.put(" article.status ", status);
        }


        params.put("@order", "  orderBy asc , create_at desc ");
        params.put("@query", " id ");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    //查询常量列表
    public static Map<String, Object> getConstantListParam(String type, String name, String value,
                                                           String comments, Long startAt, Long endAt,
                                                           Long id, Long updateStartAt, Long updateEndAt,
                                                           boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from constant");
        tables.add("constant");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type & like ", "'%" + type + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(value)) {
            params.put(" value & like ", "'%" + value + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(comments)) {
            params.put(" comments & like ", "'%" + comments + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("create_at &  <= ", endAt);
        }

        if (DataUtils.isNotNullOrEmpty(updateStartAt)) {
            params.put("update_at & >= ", updateStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(updateEndAt)) {
            params.put("update_at &  <= ", updateEndAt);
        }

        if (DataUtils.isNotNullOrEmpty(id)) {

            params.put("id", id);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " update_at desc  ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    //查询用户消息关系表
    public static Map<String, Object> getUserMessage(Integer uid, Integer status, Long messageId, Integer type) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(messageId)) {
            params.put("message_id", messageId);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        params.put("@query", "id");
        params.put("@table", "userMessage");
        return params;
    }

    public static Map<String, Object> getMessageList(String title, Integer status, Long createBy, Long startAt,
                                                     Long endAt, Integer personType, boolean count) {
        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("message");
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("message.title & like", " '%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("message.status ", " '" + status + "'");
        }

        if (DataUtils.isNotNullOrEmpty(personType)) {
            params.put("message.person_type ", " '" + personType + "'");
        } else {
            params.put("message.person_type & in ", "(" + "1,2,3,4,5" + ")");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("message.update_at & <= ", " '" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("message.update_at & >= ", " '" + startAt + "'");
        }

        if (DataUtils.isNotNullOrEmpty(createBy)) {
//            tables.add("manager");
//            params.put("message.create_by", "manager.id ");
//            params.put("manager.name & like ", "'%" + createBy + "%'");
            params.put("create_by", createBy);
        }

        if (count) {
            params.put("@query", " count(message.id) ");

        } else {
            params.put("@order", "  message.update_at desc  ");
            params.put("@query", " message.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }
    public static Map<String, Object> getWithdrawRecord(Long uid) {
        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("withdraw_record");
        params.put("status & >", "-1");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("uid", uid);
        }
        params.put("@order", "create_at desc");
        params.put("@query", "id");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

}


