package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.ApplyingRecord;
import com.ptteng.keeper.common.service.ApplyingRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ApplyingRecordServiceImpl extends BaseDaoServiceImpl implements ApplyingRecordService {

 

	private static final Log log = LogFactory.getLog(ApplyingRecordServiceImpl.class);



		   
		@Override
		public Long insert(ApplyingRecord applyingRecord)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + applyingRecord);

		if (applyingRecord == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		applyingRecord.setCreateAt(currentTimeMillis);
		applyingRecord.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(applyingRecord);
		} catch (DaoException e) {
			log.error(" insert wrong : " + applyingRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ApplyingRecord> insertList(List<ApplyingRecord> applyingRecordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (applyingRecordList == null ? "null" : applyingRecordList.size()));
      
		List<ApplyingRecord> resultList = null;

		if (CollectionUtils.isEmpty(applyingRecordList)) {
			return new ArrayList<ApplyingRecord>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ApplyingRecord applyingRecord : applyingRecordList) {
			applyingRecord.setCreateAt(currentTimeMillis);
			applyingRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ApplyingRecord>) dao.batchSave(applyingRecordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + applyingRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ApplyingRecord.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ApplyingRecord applyingRecord)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (applyingRecord == null ? "null" : applyingRecord.getId()));

		boolean result = false;

		if (applyingRecord == null) {
			return true;
		}

		applyingRecord.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(applyingRecord);
		} catch (DaoException e) {
			log.error(" update wrong : " + applyingRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + applyingRecord);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ApplyingRecord> applyingRecordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (applyingRecordList == null ? "null" : applyingRecordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(applyingRecordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ApplyingRecord applyingRecord : applyingRecordList) {
			applyingRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(applyingRecordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + applyingRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + applyingRecordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ApplyingRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ApplyingRecord applyingRecord = null;

		if (id == null) {
			return applyingRecord;
		}

		try {
			applyingRecord = (ApplyingRecord) dao.get(ApplyingRecord.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return applyingRecord;		
		}	
		  
    	   
		@Override
		public List<ApplyingRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ApplyingRecord> applyingRecord = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ApplyingRecord>();
		}

		try {
			applyingRecord = (List<ApplyingRecord>) dao.getList(ApplyingRecord.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (applyingRecord == null ? "null" : applyingRecord.size()));
    
		return applyingRecord;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getApplyingRecordIdsByMobileOrderByCreateAt(String mobile,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by mobile,start,limit  : " + mobile+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getApplyingRecordIdsByMobileOrderByCreateAt", new Object[] { mobile},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by mobile,start,limit)  : " + mobile+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getApplyingRecordIdsByProductIdAndTypeOrderByCreateAt(Long productId,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by productId,type,start,limit  : " + productId+" , "+type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getApplyingRecordIdsByProductIdAndTypeOrderByCreateAt", new Object[] { productId,type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by productId,type,start,limit)  : " + productId+" , "+type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getApplyingRecordIdsByCreateByOrderByCreateAt(Long createBy,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by createBy,start,limit  : " + createBy+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getApplyingRecordIdsByCreateByOrderByCreateAt", new Object[] { createBy},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by createBy,start,limit)  : " + createBy+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getApplyingRecordIdsByIdCardOrderByCreateAt(String idCard,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by idCard,start,limit  : " + idCard+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getApplyingRecordIdsByIdCardOrderByCreateAt", new Object[] { idCard},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by idCard,start,limit)  : " + idCard+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getApplyingRecordIdsByIdCardAndTypeOrderByCreateAt(String idCard,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by idCard,type,start,limit  : " + idCard+" , "+type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getApplyingRecordIdsByIdCardAndTypeOrderByCreateAt", new Object[] { idCard,type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by idCard,type,start,limit)  : " + idCard+" , "+type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getApplyingRecordIdsByMobileAndTypeOrderByCreateAt(String mobile,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by mobile,type,start,limit  : " + mobile+" , "+type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getApplyingRecordIdsByMobileAndTypeOrderByCreateAt", new Object[] { mobile,type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by mobile,type,start,limit)  : " + mobile+" , "+type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countApplyingRecordIdsByMobileOrderByCreateAt(String mobile)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by mobile  : " + mobile );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getApplyingRecordIdsByMobileOrderByCreateAt", new Object[] { mobile});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by mobile)  : " + mobile );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countApplyingRecordIdsByProductIdAndTypeOrderByCreateAt(Long productId,Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by productId,type  : " + productId+" , "+type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getApplyingRecordIdsByProductIdAndTypeOrderByCreateAt", new Object[] { productId,type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by productId,type)  : " + productId+" , "+type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countApplyingRecordIdsByIdCardOrderByCreateAt(String idCard)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by idCard  : " + idCard );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getApplyingRecordIdsByIdCardOrderByCreateAt", new Object[] { idCard});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by idCard)  : " + idCard );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countApplyingRecordIdsByIdCardAndTypeOrderByCreateAt(String idCard,Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by idCard,type  : " + idCard+" , "+type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getApplyingRecordIdsByIdCardAndTypeOrderByCreateAt", new Object[] { idCard,type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by idCard,type)  : " + idCard+" , "+type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countApplyingRecordIdsByMobileAndTypeOrderByCreateAt(String mobile,Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by mobile,type  : " + mobile+" , "+type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getApplyingRecordIdsByMobileAndTypeOrderByCreateAt", new Object[] { mobile,type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by mobile,type)  : " + mobile+" , "+type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getApplyingRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getApplyingRecordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countApplyingRecordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getApplyingRecordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getApplyingRecordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

