/**
 * 
 */
package com.ptteng.sca.keeper.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.keeper.common.model.IncomeRecord;
import com.ptteng.keeper.common.service.IncomeRecordService;

import java.util.List;
import java.util.Map;

public class IncomeRecordSCAClient implements IncomeRecordService {

    private IncomeRecordService incomeRecordService;

	public IncomeRecordService getIncomeRecordService() {
		return incomeRecordService;
	}
	
	
	public void setIncomeRecordService(IncomeRecordService incomeRecordService) {
		this.incomeRecordService =incomeRecordService;
	}
	
	
			   
		@Override
		public Long insert(IncomeRecord incomeRecord)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.insert(incomeRecord);
		          
		
		}	
		  
    	   
		@Override
		public List<IncomeRecord> insertList(List<IncomeRecord> incomeRecordList)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.insertList(incomeRecordList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(IncomeRecord incomeRecord)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.update(incomeRecord);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<IncomeRecord> incomeRecordList)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.updateList(incomeRecordList);
		          
		
		}	
		  
    	   
		@Override
		public IncomeRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<IncomeRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.getObjectsByIds(ids);
		          
		
		}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIncomeRecordIdsByUidAndLevelOrderByCreateAt(Long uid,Integer level,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return incomeRecordService.getIncomeRecordIdsByUidAndLevelOrderByCreateAt(uid,level,start,limit);


	}


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIncomeRecordIdsByUidAndLevelAndProductIdOrderByCreateAt(Long uid,Integer level,Long productId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return incomeRecordService.getIncomeRecordIdsByUidAndLevelAndProductIdOrderByCreateAt(uid,level,productId,start,limit);


	}



	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(Long targetId,Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.getIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(targetId,uid,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(Long targetId,Long productId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.getIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(targetId,productId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByTargetIdOrderByCreateAt(Long targetId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.getIncomeRecordIdsByTargetIdOrderByCreateAt(targetId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByUidAndProductIdOrderByCreateAt(Long uid,Long productId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.getIncomeRecordIdsByUidAndProductIdOrderByCreateAt(uid,productId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.getIncomeRecordIdsByUidOrderByCreateAt(uid,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(Long targetId,Long uid)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.countIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(targetId,uid);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(Long targetId,Long productId)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.countIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(targetId,productId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByTargetIdOrderByCreateAt(Long targetId)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.countIncomeRecordIdsByTargetIdOrderByCreateAt(targetId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByUidAndProductIdOrderByCreateAt(Long uid,Long productId)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.countIncomeRecordIdsByUidAndProductIdOrderByCreateAt(uid,productId);
	
	
	}
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIncomeRecordIdsByUidAndTypeAndLevelOrderByCreateAt(Long uid,Integer type,Integer level,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return incomeRecordService.getIncomeRecordIdsByUidAndTypeAndLevelOrderByCreateAt(uid,type,level,start,limit);


	}



    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long>  getIncomeRecordIdsByUidAndTypeOrderByCreateAt(Long uid,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

        return incomeRecordService.getIncomeRecordIdsByUidAndTypeOrderByCreateAt(uid,type,start,limit);


    }
    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long>  getIncomeRecordIdsByWrId(Long wrId,Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

        return incomeRecordService.getIncomeRecordIdsByWrId(wrId,uid,start,limit);


    }

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long>  getIncomeRecordIdsByWrIdAndStatus(Long wrId,Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

        return incomeRecordService.getIncomeRecordIdsByWrIdAndStatus(wrId,uid,status,start,limit);


    }



	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		return incomeRecordService.countIncomeRecordIdsByUidOrderByCreateAt(uid);
	
	
	}
	
		
	
		@Override
	public List<Long> getIncomeRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return incomeRecordService.getIncomeRecordIds(start, limit);
	}

	@Override
	public Integer countIncomeRecordIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return incomeRecordService.countIncomeRecordIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return incomeRecordService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return incomeRecordService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   incomeRecordService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.incomeRecordService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

