package com.ptteng.keeper.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.keeper.common.model.WithdrawIncomeRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface WithdrawIncomeRelationService extends BaseDaoService {







	public Long insert(WithdrawIncomeRelation withdrawIncomeRelation)throws ServiceException, ServiceDaoException;



	public List<WithdrawIncomeRelation> insertList(List<WithdrawIncomeRelation> withdrawIncomeRelationList)throws ServiceException, ServiceDaoException;



	public boolean delete(Long id)throws ServiceException, ServiceDaoException;



	public boolean update(WithdrawIncomeRelation withdrawIncomeRelation)throws ServiceException, ServiceDaoException;



	public boolean updateList(List<WithdrawIncomeRelation> withdrawIncomeRelationList)throws ServiceException, ServiceDaoException;



	public WithdrawIncomeRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;



	public List<WithdrawIncomeRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countWithdrawIncomeRelationIdsByWid(Long wid)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countWithdrawIncomeRelationIdsByIncomeId(Long incomeId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIncomeRecordIdsByWid(Long wid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getWithdrawIncomeRelationIdsByIncomeId(Long incomeId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getWithdrawIncomeRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countWithdrawIncomeRelationIds() throws ServiceException, ServiceDaoException;


}

