package com.ptteng.keeper.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.keeper.common.model.IncomeRecord;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface IncomeRecordService extends BaseDaoService {

	



   		   
		
		public Long insert(IncomeRecord incomeRecord)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<IncomeRecord> insertList(List<IncomeRecord> incomeRecordList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(IncomeRecord incomeRecord)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<IncomeRecord> incomeRecordList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public IncomeRecord getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<IncomeRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(Long targetId, Long uid)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(Long targetId, Long productId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIncomeRecordIdsByTargetIdOrderByCreateAt(Long targetId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIncomeRecordIdsByUidAndProductIdOrderByCreateAt(Long uid, Long productId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIncomeRecordIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(Long targetId, Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(Long targetId, Long productId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIncomeRecordIdsByTargetIdOrderByCreateAt(Long targetId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIncomeRecordIdsByUidAndProductIdOrderByCreateAt(Long uid, Long productId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIncomeRecordIdsByUidOrderByCreateAt(Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIncomeRecordIdsByUidAndLevelAndProductIdOrderByCreateAt(Long uid,Integer level,Long productId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIncomeRecordIdsByUidAndLevelOrderByCreateAt(Long uid,Integer level,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long>  getIncomeRecordIdsByUidAndTypeOrderByCreateAt(Long uid,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long>  getIncomeRecordIdsByWrId(Long wrId,Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long>  getIncomeRecordIdsByWrIdAndStatus(Long wrId,Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException;



    /**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIncomeRecordIdsByUidAndTypeAndLevelOrderByCreateAt(Long uid,Integer type,Integer level,Integer start,Integer limit)throws ServiceException, ServiceDaoException;



	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getIncomeRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countIncomeRecordIds() throws ServiceException, ServiceDaoException;
	

}

