package com.ptteng.keeper.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.keeper.common.model.Article;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ArticleService extends BaseDaoService {

	



   		   
		
		public Long insert(Article article)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Article> insertList(List<Article> articleList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Article article)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Article> articleList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Article getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Article> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countArticleIdsByTypeAndStatusOrderByPushAtAndUpdateAt(Integer type, Integer status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countArticleIdsByTypeOrderByPushAtAndUpdateAt(Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countArticleIdsByStatusOrderByPushAtAndUpdateAt(Integer status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleIdsByTypeAndStatusOrderByPushAtAndUpdateAt(Integer type, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleIdsByTypeOrderByPushAtAndUpdateAt(Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleIdsByStatusOrderByPushAtAndUpdateAt(Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getArticleIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countArticleIds() throws ServiceException, ServiceDaoException;
	

}

