package com.ptteng.keeper.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.keeper.common.model.ApplyingRecord;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ApplyingRecordService extends BaseDaoService {

	



   		   
		
		public Long insert(ApplyingRecord applyingRecord)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<ApplyingRecord> insertList(List<ApplyingRecord> applyingRecordList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(ApplyingRecord applyingRecord)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<ApplyingRecord> applyingRecordList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public ApplyingRecord getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<ApplyingRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countApplyingRecordIdsByMobileOrderByCreateAt(String mobile)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countApplyingRecordIdsByProductIdAndTypeOrderByCreateAt(Long productId, Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countApplyingRecordIdsByIdCardOrderByCreateAt(String idCard)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countApplyingRecordIdsByIdCardAndTypeOrderByCreateAt(String idCard, Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countApplyingRecordIdsByMobileAndTypeOrderByCreateAt(String mobile, Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getApplyingRecordIdsByMobileOrderByCreateAt(String mobile, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getApplyingRecordIdsByProductIdAndTypeOrderByCreateAt(Long productId, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getApplyingRecordIdsByIdCardOrderByCreateAt(String idCard, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getApplyingRecordIdsByIdCardAndTypeOrderByCreateAt(String idCard, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getApplyingRecordIdsByMobileAndTypeOrderByCreateAt(String mobile, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getApplyingRecordIdsByCreateByOrderByCreateAt(Long createBy,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getApplyingRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countApplyingRecordIds() throws ServiceException, ServiceDaoException;
	

}

