package com.ptteng.keeper.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "withdraw_record")
public class WithdrawRecord implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4538697600209986560L;	
	
		
	/**
	 *  申请中
	 * 
	 */
	public static final Integer STATUS_APPLYING = 10;
	/**
	 * 支付宝处理中
	 *
	 */
	public static final Integer STATUS_ALIPAY_PROCESSING = 20;
	/**
	 *  已提现成功
	 * 
	 */
	public static final Integer STATUS_AGREE = 30;
	/**
	 * 支付宝转账失败
	 *
	 */
	public static final Integer STATUS_ALIPAY_FAIL = 40;
	/**
	 *  被驳回
	 * 
	 */
	public static final Integer STATUS_REJECT = 50;

   	 
    private  Long id;
	
  	 
    private  Long uid;
	
  	 
    private BigDecimal amount;
    private BigDecimal disagreeAmount=BigDecimal.ZERO;

  	 
    private  Integer status;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
	/**
	 * @Fields：收款人姓名
	 */
  	private String payeeName="";
	
	/**
	 * @Fields：支付宝账号
	 */
  	private String alipayAccount="";
	/**
	 * @Fields：驳回备注
	 */
  	private String remark="";
	/**
	 * @Fields：支付宝失败备注
	 */
  	private String alipayRemark="";
	/**
	 * @Fields：收款方式（备用）
	 */
  	private Integer paymentMethod=1;
	/**
	 * @Fields：支付宝流水号
	 */
  	private String serialNumber="";
	/**
	 * @Fields：流水号（备用）
	 */
  	private String orderNo="";


         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "uid")
	public Long getUid() {
		return uid;
	}
	
	
	public void setUid(Long uid) {
		this.uid = uid;
	}
		 	@Column(name = "amount")
	public BigDecimal getAmount() {
		return amount;
	}
	
	
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
			@Column(name = "disagree_amount")
	public BigDecimal getDisagreeAmount() {
		return disagreeAmount;
	}

	public void setDisagreeAmount(BigDecimal disagreeAmount) {
		this.disagreeAmount = disagreeAmount;
	}

	@Column(name = "payee_name")
	public String getPayeeName() {
		return payeeName;
	}

	public void setPayeeName(String payeeName) {
		this.payeeName = payeeName;
	}
	@Column(name = "alipay_account")
	public String getAlipayAccount() {
		return alipayAccount;
	}

	public void setAlipayAccount(String alipayAccount) {
		this.alipayAccount = alipayAccount;
	}
	@Column(name = "remark")
	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}
	@Column(name = "alipay_remark")
	public String getAlipayRemark() {
		return alipayRemark;
	}

	public void setAlipayRemark(String alipayRemark) {
		this.alipayRemark = alipayRemark;
	}
	@Column(name = "payment_method")
	public Integer getPaymentMethod() {
		return paymentMethod;
	}

	public void setPaymentMethod(Integer paymentMethod) {
		this.paymentMethod = paymentMethod;
	}
	@Column(name = "serial_number")
	public String getSerialNumber() {
		return serialNumber;
	}

	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}
	@Column(name = "order_no")
	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

