package com.ptteng.keeper.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "product")
public class Product implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1634201989481527296L;	


		
	/**
	 *  产品类型-网贷
	 * 
	 */
	public static final Integer TYPE_LENDING = 1;
    	
	/**
	 *  产品类型-信用卡
	 * 
	 */
	public static final Integer TYPE_CARD = 2;	/**
	 *  结算类型-日结
	 *
	 */
	public static final Integer SETTLE_MODE_DAY = 1;

	/**
	 *  结算类型-周结
	 *
	 */
	public static final Integer SETTLE_MODE_WEEK = 2;
    	
	/**
	 *  结算类型-月结
	 * 
	 */
	public static final Integer SETTLE_MODE_YEAR = 3;
    	
	/**
	 *  状态-上架
	 * 
	 */
	public static final Integer STATUS_UP = 1;
    	
	/**
	 *  状态-下架
	 * 
	 */
	public static final Integer STATUS_DOWN = 0;
    	
	/**
	 *  精选模块
	 * 
	 */
	public static final Integer BELONG_MODULE_CHOICE = 1;
    	
	/**
	 *  CPA模块
	 * 
	 */
	public static final Integer BELONG_MODULE_CPA = 2;
    	
	/**
	 *  CPS模块
	 * 
	 */
	public static final Integer BELONG_MODULE_CPS = 3;
    	
	/**
	 *  返佣模式-金额
	 * 
	 */
	public static final Integer REBATE_MODE_AMOUNT = 1;
    	
	/**
	 *  返佣模式-比例
	 * 
	 */
	public static final Integer REBATE_MODE_RATE = 2;
    	
	/**
	 *  利率模式-日利率
	 * 
	 */
	public static final Integer INTEREST_RATE_MODE_DAY = 1;
    	
	/**
	 *  利率模式-月利率
	 * 
	 */
	public static final Integer INTEREST_RATE_MODE_WEEK = 2;
    	
	/**
	 *  利率模式-年利率
	 * 
	 */
	public static final Integer INTEREST_RATE_MODE_YEAR = 3;
	/**
	 *  期限类型-月
	 *
	 */
	public static final Integer DEADLINE_TYPE_MONTH = 1;
	public static final Integer DEADLINE_TYPE_DAY = 2;

   	 
    private  Long id;
	
  	 
    private  Integer type;
	
  	 
    private  String name;
	
  	 
    private  Integer settleMode;
	
  	 
    private  String settleTime;
	
  	 
    private BigDecimal firstRate;
	
  	 
    private  BigDecimal secondRate;
	
  	 
    private  String logoUrl;
	
  	 
    private  String photoUrl;

  	//信用卡 背景图
    private  String backgroundUrl="";


    private  String rebatePlan;
	
  	 
    private  String content;
	
  	 
    private  String link;
	
  	 
    private  Integer status=STATUS_UP;
	
  	 
    private  Long statusChangeAt=-1L;
	
  	 
    private  Integer applyCount=0;
	
  	//网贷 归属模块
    private  Integer belongModule=-1;
	
  	 
    private  Integer rebateMode=Product.REBATE_MODE_AMOUNT;
	
  	 
    private  BigDecimal rebateNum;

	//网贷期限下限
    private  Integer deadlineStart=-1;
	
  	//网贷期限上限
    private  Integer deadlineEnd=-1;
	
  	//网贷利率
    private  BigDecimal interestRate=BigDecimal.ZERO;
	
  	 
    private  Integer interestRateMode=INTEREST_RATE_MODE_DAY;
	
    //网贷额度开始
    private  BigDecimal amountStart=BigDecimal.ZERO;
	
  	 
    private  BigDecimal amountEnd;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
	
  	private Integer sort;


	private Integer deadlineType = DEADLINE_TYPE_MONTH;


	private Integer subType = -1;
	private BigDecimal price = BigDecimal.ZERO;

         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "type")
	public Integer getType() {
		return type;
	}
	
	
	public void setType(Integer type) {
		this.type = type;
	}
		 	@Column(name = "name")
	public String getName() {
		return name;
	}
	
	
	public void setName(String name) {
		this.name = name;
	}
		 	@Column(name = "settle_mode")
	public Integer getSettleMode() {
		return settleMode;
	}
	
	
	public void setSettleMode(Integer settleMode) {
		this.settleMode = settleMode;
	}
		 	@Column(name = "settle_time")
	public String getSettleTime() {
		return settleTime;
	}
	
	
	public void setSettleTime(String settleTime) {
		this.settleTime = settleTime;
	}
		 	@Column(name = "first_rate")
	public BigDecimal getFirstRate() {
		return firstRate;
	}
	
	
	public void setFirstRate(BigDecimal firstRate) {
		this.firstRate = firstRate;
	}
		 	@Column(name = "second_rate")
	public BigDecimal getSecondRate() {
		return secondRate;
	}
	
	
	public void setSecondRate(BigDecimal secondRate) {
		this.secondRate = secondRate;
	}
		 	@Column(name = "logo_url")
	public String getLogoUrl() {
		return logoUrl;
	}
	
	
	public void setLogoUrl(String logoUrl) {
		this.logoUrl = logoUrl;
	}
		 	@Column(name = "background_url")
	public String getBackgroundUrl() {
		return backgroundUrl;
	}


	public void setBackgroundUrl(String backgroundUrl) {
		this.backgroundUrl = backgroundUrl;
	}
		 	@Column(name = "photo_url")
	public String getPhotoUrl() {
		return photoUrl;
	}
	
	
	public void setPhotoUrl(String photoUrl) {
		this.photoUrl = photoUrl;
	}
		 	@Column(name = "rebate_plan")
	public String getRebatePlan() {
		return rebatePlan;
	}
	
	
	public void setRebatePlan(String rebatePlan) {
		this.rebatePlan = rebatePlan;
	}
		 	@Column(name = "content")
	public String getContent() {
		return content;
	}
	
	
	public void setContent(String content) {
		this.content = content;
	}
		 	@Column(name = "link")
	public String getLink() {
		return link;
	}
	
	
	public void setLink(String link) {
		this.link = link;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "status_change_at")
	public Long getStatusChangeAt() {
		return statusChangeAt;
	}
	
	
	public void setStatusChangeAt(Long statusChangeAt) {
		this.statusChangeAt = statusChangeAt;
	}
		 	@Column(name = "apply_count")
	public Integer getApplyCount() {
		return applyCount;
	}
	
	
	public void setApplyCount(Integer applyCount) {
		this.applyCount = applyCount;
	}
		 	@Column(name = "belong_module")
	public Integer getBelongModule() {
		return belongModule;
	}
	
	
	public void setBelongModule(Integer belongModule) {
		this.belongModule = belongModule;
	}
		 	@Column(name = "rebate_mode")
	public Integer getRebateMode() {
		return rebateMode;
	}
	
	
	public void setRebateMode(Integer rebateMode) {
		this.rebateMode = rebateMode;
	}
		 	@Column(name = "rebate_num")
	public BigDecimal getRebateNum() {
		return rebateNum;
	}
	
	
	public void setRebateNum(BigDecimal rebateNum) {
		this.rebateNum = rebateNum;
	}
		 	@Column(name = "deadline_start")
	public Integer getDeadlineStart() {
		return deadlineStart;
	}
	
	
	public void setDeadlineStart(Integer deadlineStart) {
		this.deadlineStart = deadlineStart;
	}
		 	@Column(name = "deadline_end")
	public Integer getDeadlineEnd() {
		return deadlineEnd;
	}
	
	
	public void setDeadlineEnd(Integer deadlineEnd) {
		this.deadlineEnd = deadlineEnd;
	}
		 	@Column(name = "interest_rate")
	public BigDecimal getInterestRate() {
		return interestRate;
	}
	
	
	public void setInterestRate(BigDecimal interestRate) {
		this.interestRate = interestRate;
	}
		 	@Column(name = "interest_rate_mode")
	public Integer getInterestRateMode() {
		return interestRateMode;
	}
	
	
	public void setInterestRateMode(Integer interestRateMode) {
		this.interestRateMode = interestRateMode;
	}
		 	@Column(name = "amount_start")
	public BigDecimal getAmountStart() {
		return amountStart;
	}
	
	
	public void setAmountStart(BigDecimal amountStart) {
		this.amountStart = amountStart;
	}
		 	@Column(name = "amount_end")
	public BigDecimal getAmountEnd() {
		return amountEnd;
	}
	
	
	public void setAmountEnd(BigDecimal amountEnd) {
		this.amountEnd = amountEnd;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
			@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}


	@Column(name = "deadline_type")
	public Integer getDeadlineType() {
		return deadlineType;
	}

	public void setDeadlineType(Integer deadlineType) {
		this.deadlineType = deadlineType;
	}
	@Column(name = "sub_type")
	public Integer getSubType() {
		return subType;
	}

	public void setSubType(Integer subType) {
		this.subType = subType;
	}
	@Column(name = "price")
	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}



}

