package com.ptteng.keeper.common.model;

import com.ptteng.keeper.common.constants.Constants;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "income_record")
public class IncomeRecord implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2134159522216619008L;	
	
		
	/**
	 *  返佣
	 * 
	 */
	public static final Integer TYPE_REBATE = 1;
    	
	/**
	 *  合伙人
	 * 
	 */
	public static final Integer TYPE_COPARTNER = 2;
	/**
	 *  合伙人
	 *
	 */
	public static final Integer TYPE_GROSS_PROFIT = 3;

	/**
	 *  代理
	 *
	 */
	public static final Integer LEVEL_ZORE = 0;
    	
	/**
	 *  下级
	 * 
	 */
	public static final Integer LEVEL_FIRST = 1;
    	
	/**
	 *  下下级
	 * 
	 */
	public static final Integer LEVEL_SECOND = 2;
	/**
	 *  状态通过
	 *
	 */
	public static final Integer STATUS_ENABLED = 1;
	public static final Integer STATUS_DISABLED = 0;

   	 
    private  Long id;
	
  	 
    private  Long uid;
	
  	 
    private  Long targetId;
	
  	 
    private  Integer type;
	
  	 
    private BigDecimal amount;
	
  	 
    private  Integer level;
	
  	 
    private  Long productId;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
    private  Integer status=STATUS_ENABLED;
    private  Long wrId=Constants.DEFAULT_LONG_NONE;

  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "uid")
	public Long getUid() {
		return uid;
	}
	
	
	public void setUid(Long uid) {
		this.uid = uid;
	}
		 	@Column(name = "target_id")
	public Long getTargetId() {
		return targetId;
	}
	
	
	public void setTargetId(Long targetId) {
		this.targetId = targetId;
	}
		 	@Column(name = "type")
	public Integer getType() {
		return type;
	}
	
	
	public void setType(Integer type) {
		this.type = type;
	}
		 	@Column(name = "amount")
	public BigDecimal getAmount() {
		return amount;
	}
	
	
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
		 	@Column(name = "level")
	public Integer getLevel() {
		return level;
	}
	
	
	public void setLevel(Integer level) {
		this.level = level;
	}
		 	@Column(name = "product_id")
	public Long getProductId() {
		return productId;
	}
	
	
	public void setProductId(Long productId) {
		this.productId = productId;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}
	@Column(name = "wr_id")
	public Long getWrId() {
		return wrId;
	}

	public void setWrId(Long wrId) {
		this.wrId = wrId;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}


	@Override
	public boolean equals(Object destination)

	{

		boolean retVal = false;

		if ((destination != null) && (destination.getClass().equals(getClass())))

		{

			IncomeRecord bean = (IncomeRecord)destination;

			if ((bean.getId() == null) && (getId() == null)) {

				retVal = true;

			} else if ((bean.getId() != null) && (bean.getId().equals(getId()))) {

				retVal = true;

			}

		}

		return retVal;

	}
}

