package com.ptteng.keeper.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "article")
public class Article implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 129270195320907776L;


	/**
	 * 推送状态
	 */
	public static final Integer STATUS_PUSH = 1;

	/**
	 * 草稿状态
	 */
	public static final Integer STATUS_WAIT = 0;


	private Long id;


	private String title;


	private Integer subType=-1;


	private Integer type;


	private Integer status=STATUS_WAIT;


	private String content;


	private String thumbUrl;


	private Integer count=0;


	private Long pushAt=-1L;


	private Long createBy=-1L;


	private Long updateBy=-1L;


	private Long updateAt;


	private Long createAt;
	private Integer sort=-1;


	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name = "id")
	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}

	@Column(name = "title")
	public String getTitle() {
		return title;
	}


	public void setTitle(String title) {
		this.title = title;
	}

	@Column(name = "sub_type")
	public Integer getSubType() {
		return subType;
	}


	public void setSubType(Integer subType) {
		this.subType = subType;
	}

	@Column(name = "type")
	public Integer getType() {
		return type;
	}


	public void setType(Integer type) {
		this.type = type;
	}

	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}


	public void setStatus(Integer status) {
		this.status = status;
	}

	@Column(name = "content")
	public String getContent() {
		return content;
	}


	public void setContent(String content) {
		this.content = content;
	}

	@Column(name = "thumb_url")
	public String getThumbUrl() {
		return thumbUrl;
	}


	public void setThumbUrl(String thumbUrl) {
		this.thumbUrl = thumbUrl;
	}

	@Column(name = "count")
	public Integer getCount() {
		return count;
	}


	public void setCount(Integer count) {
		this.count = count;
	}

	@Column(name = "push_at")
	public Long getPushAt() {
		return pushAt;
	}


	public void setPushAt(Long pushAt) {
		this.pushAt = pushAt;
	}

	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}


	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}

	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}


	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}

	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}


	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}

	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}


	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}

	@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

