package com.ptteng.keeper.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "applying_record")
public class ApplyingRecord implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 787137029890910208L;	
	
		
	/**
	 *  无数据
	 * 
	 */
	public static final Long DEFAULT_LONG_NONE = -1L;
	public static final Integer DEFAULT_INT_NONE = -1;
	/**
	 *  待达标
	 *
	 */
	public static final Integer STATUS_APPLYING = 1;

	/**
	 *  已结算
	 * 
	 */
	public static final Integer STATUS_AGREE = 2;
    	
	/**
	 *  未达标
	 * 
	 */
	public static final Integer STATUS_REJECT = 3;
    	
	/**
	 *  网贷
	 * 
	 */
	public static final Integer TYPE_LENDING = 1;
    	
	/**
	 *  信用卡
	 * 
	 */
	public static final Integer TYPE_CARD = 2;
    	
   	 
    private  Long id;
	
  	 
    private  String name;
	
  	 
    private  String mobile;
	
  	 
    private  String idCard;
	
  	 
    private  Long productId;
	
  	 
    private  Integer type;
	
  	 
    private  Integer deadline=DEFAULT_INT_NONE;
	
  	 
    private  BigDecimal amount=BigDecimal.ZERO;
	
  	 
    private  BigDecimal proxyAmount;
	
  	 
    private BigDecimal firstProxyAmount;
	
  	 
    private  BigDecimal secondProxyAmount;
	
  	 
    private  BigDecimal verifyAmount=BigDecimal.valueOf(-1);
	
  	 
    private  Integer status=STATUS_APPLYING;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "name")
	public String getName() {
		return name;
	}
	
	
	public void setName(String name) {
		this.name = name;
	}
		 	@Column(name = "mobile")
	public String getMobile() {
		return mobile;
	}
	
	
	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
		 	@Column(name = "id_card")
	public String getIdCard() {
		return idCard;
	}
	
	
	public void setIdCard(String idCard) {
		this.idCard = idCard;
	}
		 	@Column(name = "product_id")
	public Long getProductId() {
		return productId;
	}
	
	
	public void setProductId(Long productId) {
		this.productId = productId;
	}
		 	@Column(name = "type")
	public Integer getType() {
		return type;
	}
	
	
	public void setType(Integer type) {
		this.type = type;
	}
		 	@Column(name = "deadline")
	public Integer getDeadline() {
		return deadline;
	}
	
	
	public void setDeadline(Integer deadline) {
		this.deadline = deadline;
	}
		 	@Column(name = "amount")
	public BigDecimal getAmount() {
		return amount;
	}
	
	
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
		 	@Column(name = "proxy_amount")
	public BigDecimal getProxyAmount() {
		return proxyAmount;
	}
	
	
	public void setProxyAmount(BigDecimal proxyAmount) {
		this.proxyAmount = proxyAmount;
	}
		 	@Column(name = "first_proxy_amount")
	public BigDecimal getFirstProxyAmount() {
		return firstProxyAmount;
	}
	
	
	public void setFirstProxyAmount(BigDecimal firstProxyAmount) {
		this.firstProxyAmount = firstProxyAmount;
	}
		 	@Column(name = "second_proxy_amount")
	public BigDecimal getSecondProxyAmount() {
		return secondProxyAmount;
	}
	
	
	public void setSecondProxyAmount(BigDecimal secondProxyAmount) {
		this.secondProxyAmount = secondProxyAmount;
	}
		 	@Column(name = "verify_amount")
	public BigDecimal getVerifyAmount() {
		return verifyAmount;
	}
	
	
	public void setVerifyAmount(BigDecimal verifyAmount) {
		this.verifyAmount = verifyAmount;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

