package com.ptteng.keeper.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.service.ManagerService;
import com.ptteng.keeper.admin.utils.DynamicUtil;
import com.ptteng.keeper.admin.utils.FormValidationUtil;
import com.ptteng.keeper.admin.utils.LogUtil;
import com.ptteng.keeper.common.constants.Constants;
import com.ptteng.keeper.common.model.Message;
import com.ptteng.keeper.common.service.MessageService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class MessageController {

    private static final Log log = LogFactory.getLog("article");
    @Autowired
    private MessageService messageService;


    @Autowired
    private ManagerService managerService;


    /**
     * 消息详情
     *
     * @param id id
     * @return message
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/message/{id}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get message data : id= " + id);
        try {
            if (id == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                Message message = messageService.getObjectById(id);
                if (DataUtils.isNotNullOrEmpty(message)) {
                    log.info("get message data is " + message);
                    model.addAttribute("code", 0);
                    model.addAttribute("message", message);
                }else {
                    model.addAttribute("code", -1005);
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/keeper/message/json/messageDetailJson";
    }

    /**
     * 修改消息
     *
     * @param message message
     * @return 操作结果
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/message/{id}", method = RequestMethod.PUT)
    public String updateArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Message message, @PathVariable Long id) throws Exception {

        log.info("update message : aid= " + id);
        log.info("message="+message);
        Manager manager = (Manager) request.getAttribute("manager");
        if (!FormValidationUtil.createMessage(message, model)) {
            return "/common/success";
        }

        try {
            Message oMessage = messageService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(oMessage)) {
                model.addAttribute("code", -1005);
                return "common/success";
            }
            message.setId(oMessage.getId());
            message.setCreateBy(oMessage.getCreateBy());
            message.setCreateAt(oMessage.getCreateAt());
            //检查status进行处理
            if (Message.STATUS_PUSH.equals(message.getStatus())) {
                message.setPushAt(System.currentTimeMillis());
                message.setUpdateBy(manager.getId());
                log.info("message push by " + manager.getId());
            } else {
                message.setPushAt(oMessage.getPushAt());
                message.setUpdateBy(oMessage.getUpdateBy());
                log.info("message wait by " + manager.getId());
            }
            messageService.update(message);

            model.addAttribute("code", 0);
            model.addAttribute("message", message);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update article error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "common/success";
    }


    /**
     * show  添加消息
     *
     * @param message message
     * @return 操作结果
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/message", method = RequestMethod.POST)
    public String addArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Message message) throws Exception {

        log.info("create message="+message);
        Manager manager = (Manager) request.getAttribute("manager");
        if (!FormValidationUtil.createMessage(message, model)) {
            return "/common/success";
        }

        try {
            //检查status进行处理
            if (Message.STATUS_PUSH.equals(message.getStatus())) {
                message.setPushAt(System.currentTimeMillis());
                message.setUpdateBy(manager.getId());
                log.info("message push by "+manager.getId());
            } else {
                message.setPushAt(Constants.DEFAULT_LONG_NONE);
                message.setUpdateBy(Constants.DEFAULT_LONG_NONE);
                log.info("message wait by "+manager.getId());
            }
            message.setCreateBy(manager.getId());
            Long aid = messageService.insert(message);
            log.info("message create success,id="+aid);
            model.addAttribute("code", 0);
            model.addAttribute("id", aid);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add article error ");
            model.addAttribute("code", -1);
        }
        return "common/insert";
    }



    /**
     * 删除信息
     *
     * @param id id
     * @return  操作结果
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/message/{id}", method = RequestMethod.DELETE)
    public String deleteArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete article : id= " + id);
        Manager manager = (Manager) request.getAttribute("manager");
        try {
            messageService.delete(id);
            log.info("delete message success,id="+id+" ,manager="+manager.getId());
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete article error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "common/success";
    }

    /**
     * 条件查询消息
     *
     * @param page 页码
     * @param size 数据量
     * @param title 标题
     * @param subTitle 二级标题
     * @param status 状态
     * @param startTime 发布时间开始
     * @param endTime 发布时间结束
     * @return Array[article] count
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/message/search", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 String title,String subTitle, Integer status, Integer type,Long startTime, Long endTime)
            throws Exception {
        log.info("get article list:"+LogUtil.convertParam("title",title,"status",status,"subTitle",subTitle,"startTime",startTime,"endTime",endTime));
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;
        List<Long> count = null;
        List<Long> ids = null;
        log.info("pageList : page= " + start + " , size=" + size);
        try {
            Map<String, Object> param = DynamicUtil.getMessageListParam(title,subTitle,status,startTime,endTime,false);
            ids = messageService.getIdsByDynamicCondition(Message.class, param, start, size);
            count = messageService.getIdsByDynamicCondition(Message.class, param, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("get message list size is" + ids.size());
            log.info("get message total is" + total);


            List<Message> messages = messageService.getObjectsByIds(ids);
            //取manager
            List<Long> mid = MyListUtil.getList(Message.class.getDeclaredField("updateBy"), messages);
            List<Manager> managers = managerService.getObjectsByIds(mid);

            model.addAttribute("messageList", messages);
            model.addAttribute("managers", managers);

            log.info("code : " + 0);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/keeper/message/json/messageListJson";
    }
}

