package com.ptteng.keeper.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.service.ManagerService;
import com.ptteng.keeper.admin.utils.DynamicUtil;
import com.ptteng.keeper.admin.utils.FormValidationUtil;
import com.ptteng.keeper.admin.utils.LogUtil;
import com.ptteng.keeper.common.constants.Constants;
import com.ptteng.keeper.common.model.Article;
import com.ptteng.keeper.common.service.ArticleService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {

    private static final Log log = LogFactory.getLog("article");
    @Autowired
    private ArticleService articleService;

    @Autowired
    private ImgStorageUtil imgStorageUtil;

    @Autowired
    private ManagerService managerService;


    @Autowired
    private CookieUtil cookieUtil;

    // 图片上传
    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module) throws Exception {
        log.info("hello upload " + module);
        if (StringUtils.isBlank(module)) {
            module = "common";
        }
        int code = 0;
        log.info(file.getOriginalFilename());

        Long uid = cookieUtil.getID(request, response);
        try {
            String type = file.getContentType();
            long size = file.getSize();
            log.info("  size is =" + size / 1048576);
            String extend = FileUtil.getFileExtension(file.getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + extend;
            log.info("new name is " + fileName);
            String filePath = "/data/temp/" + fileName;

            File tempPic = new File(filePath);
            file.transferTo(tempPic);
            String url = this.imgStorageUtil.imgStorage(null, module + "/" + fileName, filePath);
            log.info(module + " upload success ,and file name is " + fileName + "temp path is " + filePath
                    + " access url is " + url);
            tempPic.delete();
            log.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            return "/common/success";
        }

    }


    /**
     * 单个查询展示内容
     *
     * @param aid id
     * @return article
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long aid)
            throws Exception {

        log.info("get data : id= " + aid);
        try {
            if (aid == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                Article article = articleService.getObjectById(aid);
                log.info(article);
                if (DataUtils.isNotNullOrEmpty(article)) {
                    log.info("get article data is " + article);
                    model.addAttribute("code", 0);
                    model.addAttribute("article", article);
                }else {
                    model.addAttribute("code", -1005);
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + aid);
            model.addAttribute("code", -100000);
        }

        return "/keeper/article/json/articleDetailJson";
    }

    /**
     * 修改内容
     *
     * @param article article
     * @return 操作结果
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.PUT)
    public String updateArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Article article, @PathVariable Long aid) throws Exception {

        log.info("update article : aid= " + aid);
        log.info("article="+article);
        Manager manager = (Manager) request.getAttribute("manager");
        if (!FormValidationUtil.createArticle(article, model)) {
            return "/common/success";
        }

        try {
            Article oArticle = articleService.getObjectById(aid);
            if (DataUtils.isNullOrEmpty(oArticle)) {
                model.addAttribute("code", -1005);
                return "common/success";
            }
            article.setId(oArticle.getId());
            article.setCreateBy(oArticle.getCreateBy());
            article.setCreateAt(oArticle.getCreateAt());
            //检查status进行处理
            if (Article.STATUS_PUSH.equals(article.getStatus())) {
                article.setPushAt(System.currentTimeMillis());
                article.setUpdateBy(manager.getId());
                log.info("article push by " + manager.getId());
            } else {
                article.setPushAt(oArticle.getPushAt());
                article.setUpdateBy(oArticle.getUpdateBy());
                log.info("article wait by " + manager.getId());
            }
            articleService.update(article);

            model.addAttribute("code", 0);
            model.addAttribute("article", article);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update article error,id is  " + article.getId());
            model.addAttribute("code", -100000);
        }
        return "common/success";
    }


    /**
     * show  添加内容
     *
     * @param article article
     * @return 操作结果
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/article", method = RequestMethod.POST)
    public String addArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Article article) throws Exception {

        log.info("create article="+article);
        Manager manager = (Manager) request.getAttribute("manager");
        if (!FormValidationUtil.createArticle(article, model)) {
            return "/common/success";
        }

        try {
            //检查status进行处理
            if (Article.STATUS_PUSH.equals(article.getStatus())) {
                article.setPushAt(System.currentTimeMillis());
                article.setUpdateBy(manager.getId());
                log.info("article push by "+manager.getId());
            } else {
                article.setPushAt(Constants.DEFAULT_LONG_NONE);
                article.setUpdateBy(Constants.DEFAULT_LONG_NONE);
                log.info("article wait by "+manager.getId());
            }
            article.setCreateBy(manager.getId());
            Long aid = articleService.insert(article);
            log.info("article create success,id="+aid);
            model.addAttribute("code", 0);
            model.addAttribute("id", aid);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add article error ");
            model.addAttribute("code", -100000);
        }
        return "common/insert";
    }



    /**
     * 删除内容
     *
     * @param id id
     * @return  操作结果
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/article/{id}", method = RequestMethod.DELETE)
    public String deleteArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        Manager manager = (Manager) request.getAttribute("manager");
        log.info("delete article : id= " + id);
        try {
            articleService.delete(id);
            log.info("delete article success,id="+id+" ,manager="+manager.getId());
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete article error,id is  " + id);
            model.addAttribute("code", -100000);

        }

        return "common/success";
    }

    /**
     * 条件查询内容
     *
     * @param page 页码
     * @param size 数据量
     * @param type 所属模块
     * @param title 标题
     * @param status 状态
     * @param startTime 发布时间开始
     * @param endTime 发布时间结束
     * @return Array[article] count
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/article/search", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 String title, Integer status, Integer type,Long startTime, Long endTime)
            throws Exception {
        log.info("get article list:"+LogUtil.convertParam("title",title,"status",status,"type",type,"startTime",startTime,"endTime",endTime));
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;
        List<Long> count = null;
        List<Long> ids = null;
        log.info("pageList : page= " + start + " , size=" + size);
        try {
            Map<String, Object> param = DynamicUtil.getArticleListParam(title,type,status,startTime,endTime,false);
            ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
            count = articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("get article list size is" + ids.size());
            log.info("get article total is" + total);


            List<Article> articleList = articleService.getObjectsByIds(ids);
            //取manager
            List<Long> mid = MyListUtil.getList(Article.class.getDeclaredField("updateBy"), articleList);
            List<Manager> managers = managerService.getObjectsByIds(mid);

            model.addAttribute("articleList", articleList);
            model.addAttribute("managers", managers);

            log.info("code : " + 0);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/keeper/article/json/articleListJson";
    }
}

