package com.ptteng.keeper.admin.utils;

import com.ptteng.keeper.common.model.Article;
import com.ptteng.keeper.common.model.Message;
import com.ptteng.keeper.common.model.Product;
import com.qding.common.util.DataUtils;
import org.springframework.ui.ModelMap;

public class FormValidationUtil {

    public static boolean createArticle(Article article, ModelMap modelMap) {
        if (DataUtils.isNullOrEmpty(article.getType())) {
            modelMap.addAttribute("code", -6000);
            return false;
        }
        if (DataUtils.isNullOrEmpty(article.getSubType())) {
            modelMap.addAttribute("code", -6001);
            return false;
        }
        if (DataUtils.isNullOrEmpty(article.getTitle())) {
            modelMap.addAttribute("code", -6002);
            return false;
        }
        if (DataUtils.isNullOrEmpty(article.getContent())) {
            modelMap.addAttribute("code", -6003);
            return false;
        }
        if (DataUtils.isNullOrEmpty(article.getThumbUrl())) {
            modelMap.addAttribute("code", -6004);
            return false;
        }
        if (DataUtils.isNullOrEmpty(article.getStatus())) {
            modelMap.addAttribute("code", -6005);
            return false;
        }
        return true;
    }
    public static boolean createMessage(Message message, ModelMap modelMap) {
        if (DataUtils.isNullOrEmpty(message.getTitle())) {
            modelMap.addAttribute("code", -7000);
            return false;
        }
        if (DataUtils.isNullOrEmpty(message.getSubTitle())) {
            modelMap.addAttribute("code", -7001);
            return false;
        }
        if (DataUtils.isNullOrEmpty(message.getContent())) {
            modelMap.addAttribute("code", -7002);
            return false;
        }
        if (DataUtils.isNullOrEmpty(message.getStatus())) {
            modelMap.addAttribute("code", -7003);
            return false;
        }
        return true;
    }


    /**
     * show
     * @param product product对象
     * @param modelMap Model
     * @return boolean
     * @author lishaobo
     * @date 2018/8/6
     */
    public static boolean createProduct(Product product, ModelMap modelMap) {
        if (DataUtils.isNullOrEmpty(product.getName())) {
            modelMap.addAttribute("code", -3000);
            return false;
        }
        //贷款下线
        if (DataUtils.isNullOrEmpty(product.getType())) {
            modelMap.addAttribute("code", -3018);
            return false;
        }

        if (Product.TYPE_LENDING == product.getType()) {
            //贷款下线
            if (DataUtils.isNullOrEmpty(product.getAmountStart())) {
                modelMap.addAttribute("code", -3001);
                return false;
            }
            //返佣模式
            if (DataUtils.isNullOrEmpty(product.getRebateMode())) {
                modelMap.addAttribute("code", -3013);
                return false;
            }

            //所属模块
            if (DataUtils.isNullOrEmpty(product.getBelongModule())) {
                modelMap.addAttribute("code", -3012);
                return false;
            }
            //贷款期限
            if (DataUtils.isNullOrEmpty(product.getDeadlineStart())) {
                modelMap.addAttribute("code", -3015);
                return false;
            }
            if (DataUtils.isNullOrEmpty(product.getDeadlineEnd())) {
                modelMap.addAttribute("code", -3016);
                return false;
            }
            if (product.getAmountStart().compareTo(product.getAmountEnd()) > 0) {
                modelMap.addAttribute("code", -2020);
                return false;
            }
            if (product.getDeadlineStart() > product.getDeadlineEnd()) {
                modelMap.addAttribute("code", -2021);
                return false;
            }
//            利率
            if (DataUtils.isNullOrEmpty(product.getInterestRate())) {
                modelMap.addAttribute("code", -3017);
                return false;
            }

        } else if (Product.TYPE_CARD == product.getType()) {
            //贷款期限
            if (DataUtils.isNullOrEmpty(product.getBackgroundUrl())) {
                modelMap.addAttribute("code", -3019);
                return false;
            }
        }
        if (DataUtils.isNullOrEmpty(product.getAmountEnd())) {
            modelMap.addAttribute("code", -3002);
            return false;
        }

        if (DataUtils.isNullOrEmpty(product.getSettleTime())) {
            modelMap.addAttribute("code", -3004);
            return false;
        }
        if (DataUtils.isNullOrEmpty(product.getSettleMode())) {
            modelMap.addAttribute("code", -3003);
            return false;
        }
        if (DataUtils.isNullOrEmpty(product.getFirstRate())) {
            modelMap.addAttribute("code", -3005);
            return false;
        }
        if (DataUtils.isNullOrEmpty(product.getSecondRate())) {
            modelMap.addAttribute("code", -3006);
            return false;
        }
        if (DataUtils.isNullOrEmpty(product.getLogoUrl())) {
            modelMap.addAttribute("code", -3007);
            return false;
        }
        if (DataUtils.isNullOrEmpty(product.getPhotoUrl())) {
            modelMap.addAttribute("code", -3008);
            return false;
        }
        if (DataUtils.isNullOrEmpty(product.getRebatePlan())) {
            modelMap.addAttribute("code", -3009);
            return false;
        }
        if (DataUtils.isNullOrEmpty(product.getContent())) {
            modelMap.addAttribute("code", -3009);
            return false;
        }
        if (DataUtils.isNullOrEmpty(product.getLink())) {
            modelMap.addAttribute("code", -3010);
            return false;
        }


        if (DataUtils.isNullOrEmpty(product.getRebateNum())) {
            modelMap.addAttribute("code", -3014);
            return false;
        }

        return true;
    }
}
