/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.etl;

import com.ptteng.judao.common.model.GameOrders;
import com.ptteng.judao.common.model.User;
import com.ptteng.judao.common.service.GameOrdersService;
import com.ptteng.judao.common.service.UserService;
import com.ptteng.judao.etl.unit.ConfigUtil;
import com.ptteng.judao.etl.unit.DynamicUtil;
import com.ptteng.judao.pay.service.AmountRecordService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class RapidTimeOut {
    private static final Log log = LogFactory.getLog(RapidTimeOut.class);
    private GameOrdersService gameOrdersService;
    private UserService userService;
    private AmountRecordService amountRecordService;
    private static final String tenMinutes = ConfigUtil.getProperty("ten_minutes");
    private static final int TASK_LEN = 100;
    private static boolean flag = false;

    public GameOrdersService getGameOrdersService() {
        return this.gameOrdersService;
    }

    public void setGameOrdersService(GameOrdersService gameOrdersService) {
        this.gameOrdersService = gameOrdersService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public AmountRecordService getAmountRecordService() {
        return this.amountRecordService;
    }

    public void setAmountRecordService(AmountRecordService amountRecordService) {
        this.amountRecordService = amountRecordService;
    }

    public void process() {
        log.info((Object)"\u6781\u901f\u4e0b\u5355\u8d85\u65f6\u7684\u8ba2\u5355");
        try {
            Long endAt = System.currentTimeMillis() - Long.valueOf(tenMinutes);
            Map<String, Object> map = DynamicUtil.getGameOrderRapidList(GameOrders.STATUS_UNRECEIVED, GameOrders.RAPID_YES, endAt, false);
            List ids = this.gameOrdersService.getIdsByDynamicCondition(GameOrders.class, map, Integer.valueOf(0), Integer.valueOf(100));
            if (CollectionUtils.isEmpty((Collection)ids)) {
                log.info((Object)"not get any more than 10 minute rent orders ");
                flag = false;
            } else {
                if (ids.size() < 100) {
                    log.info((Object)"not have next page");
                    flag = false;
                } else {
                    log.info((Object)"have next page");
                    flag = true;
                }
                List gameOrdersList = this.gameOrdersService.getObjectsByIds(ids);
                ArrayList<Long> billerIdList = new ArrayList<Long>();
                HashMap<Long, BigDecimal> totalAmounts = new HashMap<Long, BigDecimal>();
                for (GameOrders gameOrders : gameOrdersList) {
                    gameOrders.setStatus(GameOrders.STATUS_CANCLED);
                    Long billerId = gameOrders.getBillerId();
                    billerIdList.add(billerId);
                    if (totalAmounts.containsKey(billerId)) {
                        totalAmounts.put(billerId, ((BigDecimal)totalAmounts.get(billerId)).add(gameOrders.getTotalAmount()));
                        continue;
                    }
                    totalAmounts.put(billerId, gameOrders.getTotalAmount());
                }
                this.gameOrdersService.updateList(gameOrdersList);
                String billerIds = StringUtils.strip((String)((Object)billerIdList).toString(), (String)"[]");
                Map<String, Object> userMap = DynamicUtil.getUserByBiller(billerIds);
                List userId = this.userService.getIdsByDynamicCondition(User.class, userMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                ArrayList userList = this.userService.getObjectsByIds(userId);
                HashMap<Long, Object> userListMap = new HashMap<Long, Object>();
                for (int i = 0; i < userList.size(); ++i) {
                    userListMap.put(((User)userList.get(i)).getId(), userList.get(i));
                }
                for (Long key : userListMap.keySet()) {
                    if (!totalAmounts.containsKey(key)) continue;
                    User user = (User)userListMap.get(key);
                    BigDecimal accountStart = user.getAccountBalance();
                    user.setAccountBalance(accountStart.add((BigDecimal)totalAmounts.get(key)));
                    userListMap.remove(key);
                    userListMap.put(user.getId(), user);
                }
                userList = new ArrayList(userListMap.values());
                this.userService.updateList(userList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"update game order list  fail===");
        }
    }
}

