/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.etl;

import com.ptteng.judao.common.model.GameOrders;
import com.ptteng.judao.common.model.Studio;
import com.ptteng.judao.common.model.User;
import com.ptteng.judao.common.service.GameOrdersService;
import com.ptteng.judao.common.service.StudioService;
import com.ptteng.judao.common.service.UserService;
import com.ptteng.judao.etl.unit.ConfigUtil;
import com.ptteng.judao.etl.unit.CreateUtil;
import com.ptteng.judao.etl.unit.DynamicUtil;
import com.ptteng.judao.pay.model.AmountRecord;
import com.ptteng.judao.pay.service.AmountRecordService;
import com.ptteng.judao.pay.service.PayOrderService;
import com.qding.common.util.DataUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuestionTimeOut {
    private static final Log log = LogFactory.getLog(QuestionTimeOut.class);
    private GameOrdersService gameOrdersService;
    private UserService userService;
    private PayOrderService payOrderService;
    private AmountRecordService amountRecordService;
    private StudioService studioService;
    private static final String userTime = ConfigUtil.getProperty("one_day");
    private static final int TASK_LEN = 10;
    private static boolean flag = false;

    public PayOrderService getPayOrderService() {
        return this.payOrderService;
    }

    public void setPayOrderService(PayOrderService payOrderService) {
        this.payOrderService = payOrderService;
    }

    public StudioService getStudioService() {
        return this.studioService;
    }

    public void setStudioService(StudioService studioService) {
        this.studioService = studioService;
    }

    public AmountRecordService getAmountRecordService() {
        return this.amountRecordService;
    }

    public void setAmountRecordService(AmountRecordService amountRecordService) {
        this.amountRecordService = amountRecordService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public GameOrdersService getGameOrdersService() {
        return this.gameOrdersService;
    }

    public void setGameOrdersService(GameOrdersService gameOrdersService) {
        this.gameOrdersService = gameOrdersService;
    }

    public void process() {
        log.info((Object)"\u95ee\u9898\u8d85\u65f6\u7684\u8ba2\u5355");
        try {
            Long endAt = System.currentTimeMillis() - Long.valueOf(userTime);
            Map<String, Object> map = DynamicUtil.getGameOrderbyQuestion(GameOrders.STATUS_QUESTION, endAt, false);
            do {
                List ids;
                if (CollectionUtils.isEmpty((Collection)(ids = this.gameOrdersService.getIdsByDynamicCondition(GameOrders.class, map, Integer.valueOf(0), Integer.valueOf(10))))) {
                    log.info((Object)"not get any more than 15 minute rent orders ");
                    flag = false;
                    continue;
                }
                if (ids.size() < 10) {
                    log.info((Object)"not have next page");
                    flag = false;
                } else {
                    log.info((Object)"have next page");
                    flag = true;
                }
                List gameOrdersList = this.gameOrdersService.getObjectsByIds(ids);
                for (GameOrders gameOrders : gameOrdersList) {
                    log.info((Object)"order status question cancel");
                    if (!gameOrders.getStatus().equals(GameOrders.STATUS_QUESTION)) {
                        log.error((Object)"order status is error");
                        return;
                    }
                    if (GameOrders.GAME_ORDER_TYPE_HOME.equals(gameOrders.getType())) {
                        User user = this.userService.getObjectById(gameOrders.getBillerId());
                        User beater = this.userService.getObjectById(gameOrders.getReceiverId());
                        if (DataUtils.isNullOrEmpty((Object)beater) || DataUtils.isNullOrEmpty((Object)user)) {
                            log.info((Object)"beater is null");
                            return;
                        }
                        gameOrders.setStatus(GameOrders.STATUS_RETURNED);
                        this.gameOrdersService.update(gameOrders);
                        ArrayList<User> userList = new ArrayList<User>();
                        BigDecimal accountStart = user.getAccountBalance();
                        user.setAccountBalance(user.getAccountBalance().add(gameOrders.getTotalAmount()));
                        userList.add(user);
                        ArrayList<AmountRecord> amountRecordList = new ArrayList<AmountRecord>();
                        BigDecimal marginStart = BigDecimal.valueOf(0L);
                        BigDecimal currentLimit = BigDecimal.valueOf(0L);
                        if (User.TYPE_PERSONAL.equals(beater.getType())) {
                            marginStart = beater.getMarginBalance();
                            beater.setMarginBalance(marginStart.add(gameOrders.getMargin()));
                            userList.add(beater);
                            AmountRecord beaterAmountRecord = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), marginStart, gameOrders.getMargin(), beater.getMarginBalance(), 40, 30, 10);
                            amountRecordList.add(beaterAmountRecord);
                        } else {
                            Studio studio = this.studioService.getObjectById(beater.getStudioId());
                            if (DataUtils.isNullOrEmpty((Object)studio)) {
                                log.info((Object)"studio is null");
                                return;
                            }
                            currentLimit = studio.getCurrentLimit();
                            studio.setCurrentLimit(currentLimit.add(gameOrders.getMargin()));
                            this.studioService.update(studio);
                        }
                        this.userService.updateList(userList);
                        AmountRecord userAmountRecord = CreateUtil.getAmountRecord(user.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), accountStart, gameOrders.getPrice(), user.getAccountBalance(), 40, 10, 10);
                        amountRecordList.add(userAmountRecord);
                        this.amountRecordService.insertList(amountRecordList);
                    } else if (GameOrders.GAME_ORDER_TYPE_ADMIN.equals(gameOrders.getType())) {
                        User beater = this.userService.getObjectById(gameOrders.getReceiverId());
                        if (DataUtils.isNullOrEmpty((Object)beater)) {
                            log.info((Object)"beater is null");
                            return;
                        }
                        gameOrders.setStatus(GameOrders.STATUS_RETURNED);
                        this.gameOrdersService.update(gameOrders);
                        BigDecimal marginStart = BigDecimal.valueOf(0L);
                        BigDecimal currentLimit = BigDecimal.valueOf(0L);
                        if (User.TYPE_PERSONAL.equals(beater.getType())) {
                            marginStart = beater.getMarginBalance();
                            beater.setMarginBalance(marginStart.add(gameOrders.getMargin()));
                            this.userService.update(beater);
                            AmountRecord beaterAmountRecord = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), marginStart, gameOrders.getMargin(), beater.getMarginBalance(), 40, 30, 10);
                            this.amountRecordService.insert(beaterAmountRecord);
                        } else {
                            Studio studio = this.studioService.getObjectById(beater.getStudioId());
                            if (DataUtils.isNullOrEmpty((Object)studio)) {
                                log.info((Object)"studio is null");
                                return;
                            }
                            currentLimit = studio.getCurrentLimit();
                            studio.setCurrentLimit(currentLimit.add(gameOrders.getMargin()));
                            this.studioService.update(studio);
                        }
                    }
                    log.info((Object)"===============update game order question cancel end================");
                }
            } while (flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"update game order list  fail===");
        }
    }
}

