/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.etl;

import com.ptteng.judao.common.model.GameOrders;
import com.ptteng.judao.common.model.PlayServer;
import com.ptteng.judao.common.model.User;
import com.ptteng.judao.common.service.GameOrdersService;
import com.ptteng.judao.common.service.PlayServerService;
import com.ptteng.judao.common.service.UserService;
import com.ptteng.judao.etl.BillTimeOut;
import com.ptteng.judao.etl.unit.ConfigUtil;
import com.ptteng.judao.etl.unit.CreateUtil;
import com.ptteng.judao.etl.unit.DynamicUtil;
import com.ptteng.judao.pay.model.AmountRecord;
import com.ptteng.judao.pay.service.AmountRecordService;
import com.qding.common.util.DataUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OngoingTimeOut {
    private static final Log log = LogFactory.getLog(BillTimeOut.class);
    public static final String ONGOING_STATUS = "60,100,110";
    private GameOrdersService gameOrdersService;
    private UserService userService;
    private AmountRecordService amountRecordService;
    public PlayServerService playServerService;
    private static final String userTime = ConfigUtil.getProperty("one_day");
    private static final int TASK_LEN = 10;
    private static boolean flag = false;

    public PlayServerService getPlayServerService() {
        return this.playServerService;
    }

    public void setPlayServerService(PlayServerService playServerService) {
        this.playServerService = playServerService;
    }

    public GameOrdersService getGameOrdersService() {
        return this.gameOrdersService;
    }

    public void setGameOrdersService(GameOrdersService gameOrdersService) {
        this.gameOrdersService = gameOrdersService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public AmountRecordService getAmountRecordService() {
        return this.amountRecordService;
    }

    public void setAmountRecordService(AmountRecordService amountRecordService) {
        this.amountRecordService = amountRecordService;
    }

    public void process() {
        try {
            log.info((Object)"Time to completed player order on going order start==============");
            Long endAt = System.currentTimeMillis() - Long.valueOf(userTime);
            Map<String, Object> map = DynamicUtil.getPlayerOrderbyOngoing(ONGOING_STATUS, endAt, false);
            do {
                List ids;
                if (CollectionUtils.isEmpty((Collection)(ids = this.gameOrdersService.getIdsByDynamicCondition(GameOrders.class, map, Integer.valueOf(0), Integer.valueOf(10))))) {
                    log.info((Object)"not get any more than 15 minute rent orders ");
                    flag = false;
                    continue;
                }
                if (ids.size() < 10) {
                    log.info((Object)"not have next page");
                    flag = false;
                } else {
                    log.info((Object)"have next page");
                    flag = true;
                }
                List gameOrdersList = this.gameOrdersService.getObjectsByIds(ids);
                ArrayList<Long> billerIdList = new ArrayList<Long>();
                ArrayList<BigDecimal> totalAmountList = new ArrayList<BigDecimal>();
                LinkedList<AmountRecord> amountRecordList = new LinkedList<AmountRecord>();
                ArrayList<String> orderNoList = new ArrayList<String>();
                ArrayList<String> remarkList = new ArrayList<String>();
                for (GameOrders gameOrders : gameOrdersList) {
                    if (!ONGOING_STATUS.contains(gameOrders.getStatus().toString())) {
                        log.error((Object)"order status is error");
                        return;
                    }
                    gameOrders.setStatus(GameOrders.STATUS_COMPLETED);
                    Long billerId = gameOrders.getBillerId();
                    billerIdList.add(billerId);
                    BigDecimal totalAmount = gameOrders.getTotalAmount();
                    totalAmountList.add(totalAmount);
                    orderNoList.add(gameOrders.getGameOrderNo());
                    remarkList.add(gameOrders.getRemark());
                    Long playServerId = this.playServerService.getPlayServerIdByPlayerGameIdAndUid(gameOrders.getGameId(), billerId);
                    PlayServer playServer = this.playServerService.getObjectById(playServerId);
                    int completedCount = playServer.getOrderQuantity() + 1;
                    int improveNumber = playServer.getImproveNumber();
                    BigDecimal unitPrice = playServer.getUnitPrice();
                    String increasePrice = ConfigUtil.getProperty("increase_price");
                    int increaseOrderCount = Integer.parseInt(ConfigUtil.getProperty("player_order_count"));
                    if (completedCount > increaseOrderCount * (improveNumber + 1)) {
                        playServer.setImproveNumber(Integer.valueOf(improveNumber + 1));
                        unitPrice.add(new BigDecimal(Long.parseLong(increasePrice)));
                        playServer.setUnitPrice(unitPrice);
                    }
                    playServer.setOrderQuantity(Integer.valueOf(completedCount));
                    boolean updatePlayServerResult = this.playServerService.update(playServer);
                    log.info((Object)("update Player result  is" + updatePlayServerResult));
                }
                this.gameOrdersService.updateList(gameOrdersList);
                ArrayList billerList = this.userService.getObjectsByIds(billerIdList);
                HashMap<Long, User> idUser = new HashMap<Long, User>();
                for (int x = 0; x < billerList.size(); ++x) {
                    User user = (User)billerList.get(x);
                    if (DataUtils.isNullOrEmpty(idUser.get(user.getId()))) {
                        BigDecimal startAmount = user.getAccountBalance();
                        BigDecimal totalAmount = (BigDecimal)totalAmountList.get(x);
                        BigDecimal endAmount = startAmount.add(totalAmount);
                        user.setAccountBalance(endAmount);
                        AmountRecord receiverAmountRecord = CreateUtil.getAmountRecord(user.getId(), (String)orderNoList.get(x), "\u966a\u73a9\u672a\u786e\u8ba4\u9000\u5355", (String)remarkList.get(x), startAmount, totalAmount, endAmount, 40, 10, 10);
                        amountRecordList.add(receiverAmountRecord);
                        idUser.put(user.getId(), user);
                        continue;
                    }
                    User newUser = (User)idUser.get(user.getId());
                    BigDecimal startAmount = newUser.getAccountBalance();
                    BigDecimal totalAmount = (BigDecimal)totalAmountList.get(x);
                    BigDecimal endAmount = startAmount.add(totalAmount);
                    newUser.setAccountBalance(endAmount);
                    idUser.put(newUser.getId(), newUser);
                    AmountRecord receiverAmountRecord = CreateUtil.getAmountRecord(newUser.getId(), (String)orderNoList.get(x), "\u966a\u73a9\u672a\u786e\u8ba4\u9000\u5355", (String)remarkList.get(x), startAmount, totalAmount, endAmount, 40, 10, 10);
                    amountRecordList.add(receiverAmountRecord);
                    idUser.put(newUser.getId(), newUser);
                }
                billerList = new ArrayList(idUser.values());
                boolean updateUserResult = this.userService.updateList(billerList);
                log.info((Object)("batch to update user  accountBalance result" + updateUserResult));
                this.amountRecordService.insertList(amountRecordList);
            } while (flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"update game order list  fail===");
        }
    }
}

