/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.etl;

import com.ptteng.judao.common.model.GameOrders;
import com.ptteng.judao.common.service.GameOrdersService;
import com.ptteng.judao.common.service.StudioService;
import com.ptteng.judao.common.service.UserService;
import com.ptteng.judao.etl.unit.ConfigUtil;
import com.ptteng.judao.etl.unit.DynamicUtil;
import com.ptteng.judao.pay.service.AmountRecordService;
import com.ptteng.judao.pay.service.PayOrderService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpectedTimeOut {
    private static final Log log = LogFactory.getLog(ExpectedTimeOut.class);
    private GameOrdersService gameOrdersService;
    private UserService userService;
    private PayOrderService payOrderService;
    private AmountRecordService amountRecordService;
    private StudioService studioService;
    private static final String userTime = ConfigUtil.getProperty("three_day");
    private static final int TASK_LEN = 10;
    private static boolean flag = false;

    public PayOrderService getPayOrderService() {
        return this.payOrderService;
    }

    public void setPayOrderService(PayOrderService payOrderService) {
        this.payOrderService = payOrderService;
    }

    public StudioService getStudioService() {
        return this.studioService;
    }

    public void setStudioService(StudioService studioService) {
        this.studioService = studioService;
    }

    public AmountRecordService getAmountRecordService() {
        return this.amountRecordService;
    }

    public void setAmountRecordService(AmountRecordService amountRecordService) {
        this.amountRecordService = amountRecordService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public GameOrdersService getGameOrdersService() {
        return this.gameOrdersService;
    }

    public void setGameOrdersService(GameOrdersService gameOrdersService) {
        this.gameOrdersService = gameOrdersService;
    }

    public void process() {
        log.info((Object)"\u903e\u671f\u8d85\u65f6\u7684\u8ba2\u5355");
        try {
            Long endAt = System.currentTimeMillis() - Long.valueOf(userTime);
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(GameOrders.STATUS_CHILD);
            list.add(GameOrders.STATUS_RECEIVED_PAID);
            Map<String, Object> map = DynamicUtil.getGameOrderbyOverdue(list, endAt, false);
            do {
                List ids;
                if (CollectionUtils.isEmpty((Collection)(ids = this.gameOrdersService.getIdsByDynamicCondition(GameOrders.class, map, Integer.valueOf(0), Integer.valueOf(10))))) {
                    log.info((Object)"not get any more than 15 minute rent orders ");
                    flag = false;
                    continue;
                }
                if (ids.size() < 10) {
                    log.info((Object)"not have next page");
                    flag = false;
                } else {
                    log.info((Object)"have next page");
                    flag = true;
                }
                List gameOrdersList = this.gameOrdersService.getObjectsByIds(ids);
                for (GameOrders gameOrders : gameOrdersList) {
                    log.info((Object)"order status unchecked");
                    if (!GameOrders.STATUS_RECEIVED_PAID.equals(gameOrders.getStatus()) && !GameOrders.STATUS_CHILD.equals(gameOrders.getStatus())) {
                        log.error((Object)"order status is error");
                        return;
                    }
                    gameOrders.setStatus(GameOrders.STATUS_UNCHECKED);
                    this.gameOrdersService.update(gameOrders);
                    log.info((Object)"===============update game order question Unchecked end================");
                }
            } while (flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"update game order list  fail===");
        }
    }
}

