/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.etl;

import com.ptteng.judao.common.model.GameOrders;
import com.ptteng.judao.common.model.User;
import com.ptteng.judao.common.service.GameOrdersService;
import com.ptteng.judao.common.service.UserService;
import com.ptteng.judao.etl.BillTimeOut;
import com.ptteng.judao.etl.unit.ConfigUtil;
import com.ptteng.judao.etl.unit.CreateUtil;
import com.ptteng.judao.etl.unit.DynamicUtil;
import com.ptteng.judao.pay.model.AmountRecord;
import com.ptteng.judao.pay.service.AmountRecordService;
import com.qding.common.util.DataUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfirmTimeOut {
    private static final Log log = LogFactory.getLog(BillTimeOut.class);
    private GameOrdersService gameOrdersService;
    private UserService userService;
    private AmountRecordService amountRecordService;
    private static final String userTime = ConfigUtil.getProperty("user_time");
    private static final int TASK_LEN = 100;
    private static boolean flag = false;

    public GameOrdersService getGameOrdersService() {
        return this.gameOrdersService;
    }

    public void setGameOrdersService(GameOrdersService gameOrdersService) {
        this.gameOrdersService = gameOrdersService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public AmountRecordService getAmountRecordService() {
        return this.amountRecordService;
    }

    public void setAmountRecordService(AmountRecordService amountRecordService) {
        this.amountRecordService = amountRecordService;
    }

    public void process() {
        try {
            log.info((Object)"Time to cancel player not confirm order start==============");
            Long endAt = System.currentTimeMillis() - Long.valueOf(userTime);
            Map<String, Object> map = DynamicUtil.getPlayerOrderNoConfirm(GameOrders.STATUS_RECEIVED, endAt, false);
            do {
                List ids;
                if (CollectionUtils.isEmpty((Collection)(ids = this.gameOrdersService.getIdsByDynamicCondition(GameOrders.class, map, Integer.valueOf(0), Integer.valueOf(100))))) {
                    log.info((Object)"not get any more than 15 minute rent orders ");
                    flag = false;
                    continue;
                }
                if (ids.size() < 100) {
                    log.info((Object)"not have next page");
                    flag = false;
                } else {
                    log.info((Object)"have next page");
                    flag = true;
                }
                List gameOrdersList = this.gameOrdersService.getObjectsByIds(ids);
                ArrayList<Long> receiverIdList = new ArrayList<Long>();
                ArrayList<BigDecimal> totalAmountList = new ArrayList<BigDecimal>();
                LinkedList<AmountRecord> amountRecordList = new LinkedList<AmountRecord>();
                ArrayList<String> orderNoList = new ArrayList<String>();
                ArrayList<String> remarkList = new ArrayList<String>();
                for (GameOrders gameOrders : gameOrdersList) {
                    if (!gameOrders.getStatus().equals(GameOrders.STATUS_RECEIVED)) {
                        log.error((Object)"order status is error");
                        return;
                    }
                    gameOrders.setStatus(GameOrders.STATUS_CANCLED);
                    Long receiverId = gameOrders.getReceiverId();
                    receiverIdList.add(receiverId);
                    BigDecimal totalAmount = gameOrders.getTotalAmount();
                    totalAmountList.add(totalAmount);
                    orderNoList.add(gameOrders.getGameOrderNo());
                    remarkList.add(gameOrders.getRemark());
                }
                this.gameOrdersService.updateList(gameOrdersList);
                ArrayList receiverList = this.userService.getObjectsByIds(receiverIdList);
                HashMap<Long, User> idUser = new HashMap<Long, User>();
                for (int x = 0; x < receiverList.size(); ++x) {
                    User user = (User)receiverList.get(x);
                    if (DataUtils.isNullOrEmpty(idUser.get(user.getId()))) {
                        BigDecimal startAmount = user.getAccountBalance();
                        BigDecimal totalAmount = (BigDecimal)totalAmountList.get(x);
                        BigDecimal endAmount = startAmount.add(totalAmount);
                        user.setAccountBalance(endAmount);
                        AmountRecord receiverAmountRecord = CreateUtil.getAmountRecord(user.getId(), (String)orderNoList.get(x), "\u966a\u73a9\u672a\u786e\u8ba4\u9000\u5355", (String)remarkList.get(x), startAmount, totalAmount, endAmount, 40, 10, 10);
                        amountRecordList.add(receiverAmountRecord);
                        idUser.put(user.getId(), user);
                        continue;
                    }
                    User newUser = (User)idUser.get(user.getId());
                    BigDecimal startAmount = newUser.getAccountBalance();
                    BigDecimal totalAmount = (BigDecimal)totalAmountList.get(x);
                    BigDecimal endAmount = startAmount.add(totalAmount);
                    newUser.setAccountBalance(endAmount);
                    idUser.put(newUser.getId(), newUser);
                    AmountRecord receiverAmountRecord = CreateUtil.getAmountRecord(newUser.getId(), (String)orderNoList.get(x), "\u966a\u73a9\u672a\u786e\u8ba4\u9000\u5355", (String)remarkList.get(x), startAmount, totalAmount, endAmount, 40, 10, 10);
                    amountRecordList.add(receiverAmountRecord);
                    idUser.put(newUser.getId(), newUser);
                }
                receiverList = new ArrayList(idUser.values());
                boolean updateUserResult = this.userService.updateList(receiverList);
                log.info((Object)("batch to update user  accountBalance result" + updateUserResult));
                this.amountRecordService.insertList(amountRecordList);
            } while (flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"update game order list  fail===");
        }
    }
}

