/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.etl;

import com.ptteng.judao.common.model.GameOrders;
import com.ptteng.judao.common.model.Studio;
import com.ptteng.judao.common.model.User;
import com.ptteng.judao.common.service.GameOrdersService;
import com.ptteng.judao.common.service.StudioService;
import com.ptteng.judao.common.service.UserService;
import com.ptteng.judao.etl.unit.ConfigUtil;
import com.ptteng.judao.etl.unit.CreateUtil;
import com.ptteng.judao.etl.unit.DynamicUtil;
import com.ptteng.judao.pay.model.AmountRecord;
import com.ptteng.judao.pay.service.AmountRecordService;
import com.ptteng.judao.pay.service.PayOrderService;
import com.qding.common.util.DataUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcceptanceTimeOut {
    private static final Log log = LogFactory.getLog(AcceptanceTimeOut.class);
    private GameOrdersService gameOrdersService;
    private UserService userService;
    private PayOrderService payOrderService;
    private AmountRecordService amountRecordService;
    private StudioService studioService;
    private static final String userTime = ConfigUtil.getProperty("one_day");
    private static final int TASK_LEN = 10;
    private static boolean flag = false;

    public PayOrderService getPayOrderService() {
        return this.payOrderService;
    }

    public void setPayOrderService(PayOrderService payOrderService) {
        this.payOrderService = payOrderService;
    }

    public StudioService getStudioService() {
        return this.studioService;
    }

    public void setStudioService(StudioService studioService) {
        this.studioService = studioService;
    }

    public AmountRecordService getAmountRecordService() {
        return this.amountRecordService;
    }

    public void setAmountRecordService(AmountRecordService amountRecordService) {
        this.amountRecordService = amountRecordService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public GameOrdersService getGameOrdersService() {
        return this.gameOrdersService;
    }

    public void setGameOrdersService(GameOrdersService gameOrdersService) {
        this.gameOrdersService = gameOrdersService;
    }

    public void process() {
        try {
            log.info((Object)"\u9a8c\u6536\u8d85\u65f6\u7684\u8ba2\u5355");
            Long endAt = System.currentTimeMillis() - Long.valueOf(userTime);
            Map<String, Object> map = DynamicUtil.getGameOrderAcceptanceTimeOut(GameOrders.STATUS_UNCHECKED, endAt, false);
            do {
                List ids;
                if (CollectionUtils.isEmpty((Collection)(ids = this.gameOrdersService.getIdsByDynamicCondition(GameOrders.class, map, Integer.valueOf(0), Integer.valueOf(10))))) {
                    log.info((Object)"not get any more than 15 minute rent orders ");
                    flag = false;
                    continue;
                }
                if (ids.size() < 10) {
                    log.info((Object)"not have next page");
                    flag = false;
                } else {
                    log.info((Object)"have next page");
                    flag = true;
                }
                List gameOrdersList = this.gameOrdersService.getObjectsByIds(ids);
                for (GameOrders gameOrders : gameOrdersList) {
                    log.info((Object)"order status completed");
                    if (!gameOrders.getStatus().equals(GameOrders.STATUS_UNCHECKED)) {
                        log.error((Object)"order status is error");
                        return;
                    }
                    User beater = this.userService.getObjectById(gameOrders.getReceiverId());
                    if (DataUtils.isNullOrEmpty((Object)beater)) {
                        log.info((Object)"beater is null");
                        return;
                    }
                    gameOrders.setStatus(GameOrders.STATUS_COMPLETED);
                    this.gameOrdersService.update(gameOrders);
                    BigDecimal accountStart = beater.getAccountBalance();
                    beater.setAccountBalance(accountStart.add(gameOrders.getTotalAmount()));
                    ArrayList<AmountRecord> amountRecordList = new ArrayList<AmountRecord>();
                    if (User.TYPE_PERSONAL.equals(beater.getType())) {
                        BigDecimal marginStart = beater.getMarginBalance();
                        beater.setMarginBalance(marginStart.add(gameOrders.getMargin()));
                        AmountRecord beaterMargin = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), marginStart, gameOrders.getMargin(), beater.getMarginBalance(), 40, 30, 10);
                        amountRecordList.add(beaterMargin);
                    } else {
                        Studio studio = this.studioService.getObjectById(beater.getStudioId());
                        if (DataUtils.isNullOrEmpty((Object)studio)) {
                            log.info((Object)"studio is null");
                            return;
                        }
                        BigDecimal currentLimit = studio.getCurrentLimit();
                        studio.setCurrentLimit(currentLimit.add(gameOrders.getMargin()));
                        studio.setUpdateBy(beater.getId());
                        this.studioService.update(studio);
                    }
                    this.userService.update(beater);
                    AmountRecord beaterPrice = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), accountStart, gameOrders.getPrice(), beater.getAccountBalance(), 50, 10, 10);
                    amountRecordList.add(beaterPrice);
                    this.amountRecordService.insertList(amountRecordList);
                    log.info((Object)"===============update game order question Completed end================");
                }
            } while (flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"update game order list  fail===");
        }
    }
}

