/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.judao.common.model.GameArea;
import com.ptteng.judao.common.service.GameAreaService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GameAreaServiceImpl
extends BaseDaoServiceImpl
implements GameAreaService {
    private static final Log log = LogFactory.getLog(GameAreaServiceImpl.class);

    public Long insert(GameArea gameArea) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + gameArea));
        if (gameArea == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        gameArea.setCreateAt(Long.valueOf(currentTimeMillis));
        gameArea.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)gameArea);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + gameArea));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<GameArea> insertList(List<GameArea> gameAreaList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (gameAreaList == null ? "null" : Integer.valueOf(gameAreaList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(gameAreaList)) {
            return new ArrayList<GameArea>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GameArea gameArea : gameAreaList) {
            gameArea.setCreateAt(Long.valueOf(currentTimeMillis));
            gameArea.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(gameAreaList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + gameAreaList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(GameArea.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(GameArea gameArea) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (gameArea == null ? "null" : gameArea.getId())));
        boolean result = false;
        if (gameArea == null) {
            return true;
        }
        gameArea.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)gameArea);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + gameArea));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + gameArea));
        }
        return result;
    }

    public boolean updateList(List<GameArea> gameAreaList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (gameAreaList == null ? "null" : Integer.valueOf(gameAreaList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(gameAreaList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GameArea gameArea : gameAreaList) {
            gameArea.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(gameAreaList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + gameAreaList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + gameAreaList.size()));
        return result;
    }

    public GameArea getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        GameArea gameArea = null;
        if (id == null) {
            return gameArea;
        }
        try {
            gameArea = (GameArea)this.dao.get(GameArea.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return gameArea;
    }

    public List<GameArea> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List gameArea = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<GameArea>();
        }
        try {
            gameArea = this.dao.getList(GameArea.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (gameArea == null ? "null" : Integer.valueOf(gameArea.size()))));
        return gameArea;
    }

    public List<Long> getGameAreaIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameAreaIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGameAreaIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getGameAreaIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getGameAreaIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getGameAreaIdsByGId(Long gId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by gId,start,limit  : " + gId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameAreaIdsByGId", new Object[]{gId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by gId,start,limit)  : " + gId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGameAreaIdsByGId(Long gId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by gId  : " + gId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGameAreaIdsByGId", new Object[]{gId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by gId)  : " + gId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getGameAreaIdsByFatherId(Long fatherId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by fatherId,start,limit  : " + fatherId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameAreaIdsByFatherId", new Object[]{fatherId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by fatherId,start,limit)  : " + fatherId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGameAreaIdsByFatherId(Long fatherId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by fatherId  : " + fatherId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGameAreaIdsByFatherId", new Object[]{fatherId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by fatherId)  : " + fatherId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Long getGameAreaIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getGameAreaIdByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getGameAreaIdByNameAndGId(String name, Long gId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name,gId  : " + name + " , " + gId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getGameAreaIdByNameAndGId", new Object[]{name, gId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name,gId  : " + name + " , " + gId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getGameAreaIdByNameAndFatherId(String name, Long fatherId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name,fatherId  : " + name + " , " + fatherId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getGameAreaIdByNameAndFatherId", new Object[]{name, fatherId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name,fatherId  : " + name + " , " + fatherId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }
}

