/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.impl;

import com.ptteng.iqiyi.admin.mapper.RoleMapper;
import com.ptteng.iqiyi.admin.model.Role;
import com.ptteng.iqiyi.admin.service.RoleService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Resource
    private RoleMapper roleMapper;

    public List<Role> findListbyIds(List<Long> list) {
        List<Role> roleList = this.roleMapper.findListbyIds(list);
        return roleList;
    }

    public List<Long> findIdsList() {
        List<Long> roleIdsList = this.roleMapper.findIdsList();
        return roleIdsList;
    }

    public Long deleteById(Long id) {
        this.roleMapper.deleteById(id);
        return id;
    }

    public Long updateById(Long id, Role role) {
        role.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        this.roleMapper.updateById(role, id);
        return role.getId();
    }

    public Role selectById(Long id) {
        log.info("selectById========" + id);
        Role role = this.roleMapper.findById(id);
        return role;
    }

    public Long insertRole(Role role) {
        role.setId(null);
        role.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        role.setCreateAt(Long.valueOf(System.currentTimeMillis()));
        this.roleMapper.insertRole(role);
        return role.getId();
    }

    public Long updateByPrimaryKeySelective(Role role) {
        log.info("updateByPrimaryKeySelective======" + role);
        role.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        this.roleMapper.updateByPrimaryKeySelective(role);
        return role.getId();
    }

    public List<Role> selectByName(String name) {
        return this.roleMapper.selectByName(name);
    }
}

