/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.impl;

import com.ptteng.iqiyi.admin.mapper.RoleModuleMapper;
import com.ptteng.iqiyi.admin.model.RoleModule;
import com.ptteng.iqiyi.admin.service.RoleModuleService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RoleModuleServiceImpl
implements RoleModuleService {
    private static final Logger log = LoggerFactory.getLogger(RoleModuleServiceImpl.class);
    @Resource
    private RoleModuleMapper roleModuleMapper;

    public boolean insertList(List<RoleModule> roleModules) {
        log.info("insert role module List========" + roleModules.size());
        long currentTimeMillis = System.currentTimeMillis();
        for (RoleModule roleModule : roleModules) {
            roleModule.setCreateAt(Long.valueOf(currentTimeMillis));
            roleModule.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        boolean result = this.roleModuleMapper.insertList(roleModules);
        return result;
    }

    public boolean deleteByRid(Long rid) {
        log.info("deleteByRid=======" + rid);
        return this.roleModuleMapper.deleteByRid(rid);
    }

    public List<Long> getMidsByRid(Long rid) {
        log.info("getMidsByRid=======" + rid);
        List<Long> mids = this.roleModuleMapper.findMidsByRid(rid);
        log.info("mids========" + mids);
        return mids;
    }

    public Long updateOne(Long id, RoleModule roleModule) {
        log.info("updateById=======" + roleModule);
        int result = this.roleModuleMapper.updateByPrimaryKeySelective(roleModule);
        Long finalResult = Long.parseLong(result + "");
        return finalResult;
    }

    public List<Long> getRoleModuleIdsByRid(Long rid) {
        log.info("getRoleModuleIdsByRid=======" + rid);
        List<Long> ids = this.roleModuleMapper.findidsByRid(rid);
        log.info("ids========" + ids);
        return ids;
    }

    public List<RoleModule> getObjectsByIds(List<Long> list) {
        log.info("getRoleModuleIdsByRid=======" + list);
        List<RoleModule> roleModules = this.roleModuleMapper.getObjectsByIds(list);
        log.info("roleModules========" + roleModules);
        return roleModules;
    }
}

