/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.impl;

import com.ptteng.iqiyi.admin.mapper.ModuleMapper;
import com.ptteng.iqiyi.admin.model.Module;
import com.ptteng.iqiyi.admin.service.ModuleService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class ModuleServiceImpl
implements ModuleService {
    private static final Logger log = LoggerFactory.getLogger(ModuleServiceImpl.class);
    @Resource
    private ModuleMapper moduleMapper;

    public List<Module> findList() {
        List<Module> moduleList = this.moduleMapper.findList();
        return moduleList;
    }

    public List<Long> findIdsList() {
        List<Long> moduleIdsList = this.moduleMapper.findIdsList();
        return moduleIdsList;
    }

    public Long deleteById(Long id) {
        this.moduleMapper.deleteById(id);
        return id;
    }

    public Module selectById(Long id) {
        Module module = this.moduleMapper.findById(id);
        return module;
    }

    public List<Module> getObjectsByIds(@RequestParam(name="mids") List<Long> mids) {
        log.info("getObjectsByIds========" + mids);
        if (CollectionUtils.isEmpty(mids)) {
            return null;
        }
        List<Module> modules = this.moduleMapper.getObjectsByIds(mids);
        return modules;
    }

    public Long insertModule(Module module) {
        module.setId(null);
        module.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        module.setCreateAt(Long.valueOf(System.currentTimeMillis()));
        this.moduleMapper.insertModule(module);
        return module.getId();
    }

    public Long updateByPrimaryKeySelective(Module module, Long id) {
        module.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        this.moduleMapper.updateByPrimaryKeySelective(module);
        return module.getId();
    }

    public List<Module> findListbyIds(List<Long> ids) {
        List<Module> moduleList = this.moduleMapper.getObjectsByIds(ids);
        return moduleList;
    }
}

