/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.controller;

import com.ptteng.iqiyi.admin.model.RoleModule;
import com.ptteng.iqiyi.admin.service.RoleModuleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RoleModuleController {
    private static final Logger log = LoggerFactory.getLogger(RoleModuleController.class);
    @Autowired
    private RoleModuleService roleModuleService;

    @PostMapping(value={"/a/u/rolemodule/list"})
    public boolean insertList(@RequestBody List<RoleModule> roleModules) {
        log.info("add rolemodule list=====" + roleModules.size());
        boolean result = this.roleModuleService.insertList(roleModules);
        log.info("result=======" + result);
        return result;
    }

    @DeleteMapping(value={"/a/u/rolemodule/{rid}"})
    public boolean deleteByRid(@PathVariable(value="rid") Long rid) {
        log.info("delete rid====" + rid);
        boolean result = this.roleModuleService.deleteByRid(rid);
        log.info("result =====" + result);
        return result;
    }

    @GetMapping(value={"/a/u/rolemodule/{rid}"})
    public List<Long> getMidsByRid(@PathVariable(value="rid") Long rid) {
        List ids = this.roleModuleService.getMidsByRid(rid);
        log.info("result ids=====" + ids);
        return ids;
    }

    @PutMapping(value={"/a/u/rolemodule/{id}"})
    public Long updateOne(@PathVariable(value="id") Long id, @RequestBody RoleModule roleModule) {
        Long result = this.roleModuleService.updateOne(id, roleModule);
        log.info("result=====" + result);
        return result;
    }

    @GetMapping(value={"/a/u/role/{rid}/module"})
    public List<Long> getRoleModuleIdsByRid(@PathVariable(value="rid") Long rid) {
        List ids = this.roleModuleService.getRoleModuleIdsByRid(rid);
        log.info("result ids=====" + ids);
        return ids;
    }

    @GetMapping(value={"/a/u/rolemodule/list"})
    List<RoleModule> getObjectsByIds(@RequestParam(value="ids") List<Long> list) {
        List roleModules = this.roleModuleService.getObjectsByIds(list);
        log.info("result roleModules=====" + roleModules);
        return roleModules;
    }
}

