/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.controller;

import com.ptteng.iqiyi.admin.model.Role;
import com.ptteng.iqiyi.admin.service.RoleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RoleController {
    private static final Logger log = LoggerFactory.getLogger(RoleController.class);
    @Autowired
    private RoleService roleService;

    @PostMapping(value={"/a/u/role"})
    public Long addRole(@RequestBody Role role) {
        log.info("addRole======role===" + role);
        Long result = this.roleService.insertRole(role);
        log.info("result===========" + result);
        return result;
    }

    @GetMapping(value={"/a/u/multi/role"})
    public List<Role> findListbyIds(@RequestParam(value="page", required=false) Integer page, @RequestParam(value="size", required=false) Integer size, @RequestParam(value="ids", required=true) List<Long> ids) {
        log.info("listRole=======page==" + page + "=====size====" + size);
        List roleList = this.roleService.findListbyIds(ids);
        log.info("rolelist======" + roleList.size());
        return roleList;
    }

    @GetMapping(value={"/a/u/role/list"})
    public List<Long> findIdsList(@RequestParam(value="page", required=false) Integer page, @RequestParam(value="size", required=false) Integer size) {
        log.info("listRole=======page==" + page + "=====size====" + size);
        List roleIdsList = this.roleService.findIdsList();
        log.info("rolelist======" + roleIdsList.size());
        return roleIdsList;
    }

    @DeleteMapping(value={"/a/u/role/{rid}"})
    public Long deleteRole(@PathVariable(value="rid") Long rid) {
        log.info("deleteRole====" + rid);
        Long result = this.roleService.deleteById(rid);
        return result;
    }

    @PutMapping(value={"/a/u/role"})
    public Long updateRole(@RequestBody Role role) {
        log.info("updateRole=========role======" + role);
        Long result = this.roleService.updateByPrimaryKeySelective(role);
        return result;
    }

    @GetMapping(value={"/a/u/role/{rid}"})
    public Role getRole(@PathVariable(value="rid") Long rid) {
        log.info("getRole==========" + rid);
        Role role = this.roleService.selectById(rid);
        return role;
    }

    @GetMapping(value={"/a/u/role/search"})
    public List<Role> getByName(String name) {
        log.info("getByName=======" + name);
        List roles = this.roleService.selectByName(name);
        log.info("roles info", (Object)roles);
        return roles;
    }
}

