/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.controller;

import com.ptteng.iqiyi.admin.model.Movie;
import com.ptteng.iqiyi.admin.service.MovieService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MovieController {
    private static final Logger log = LoggerFactory.getLogger(MovieController.class);
    @Autowired
    private MovieService movieService;

    @RequestMapping(value={"/a/u/movie/{type}"}, method={RequestMethod.POST})
    public Long createMovie(@RequestBody Movie movie, @PathVariable(value="type") Integer type) {
        log.info("service\u6a21\u5757 \u65b0\u589emovie\u5165\u53c2 movie={} type ={}", (Object)movie, (Object)type);
        Long movieID = this.movieService.saveMovie(type, movie);
        log.info("service\u6a21\u5757 \u65b0\u589emovie id = {}", (Object)movieID);
        return movieID;
    }

    @RequestMapping(value={"/a/u/movie/{id}"}, method={RequestMethod.DELETE})
    public Long deleteMovie(@PathVariable(value="id") Long id) {
        return this.movieService.deleteMovie(id);
    }

    @RequestMapping(value={"/a/u/movie/{id}"}, method={RequestMethod.PUT})
    public Long updateMovie(@RequestBody Movie movie, @PathVariable(value="id") Long id) {
        log.info("service\u6a21\u5757 \u66f4\u65b0movie id={}", (Object)id);
        return this.movieService.updateMovie(id, movie);
    }

    @RequestMapping(value={"/a/movie/{id}"}, method={RequestMethod.GET})
    public Movie findOneMovie(@PathVariable(value="id") Long id) {
        log.info("service\u6a21\u5757 \u67e5\u8be2movie \u8be6\u7ec6id={}", (Object)id);
        return this.movieService.findMovieById(id);
    }

    @RequestMapping(value={"/a/movie/search/{type}"}, method={RequestMethod.GET})
    public List<Movie> findAllMovie(@PathVariable(value="type") Integer type, @RequestParam(value="title", required=false) String title, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="startAt", required=false) Long startAt, @RequestParam(value="endAt", required=false) Long endAt) {
        log.info("service\u6a21\u5757 getMovieList= type=" + type + "title=" + title + "status=" + status + "startAt=" + startAt + "endAt=" + endAt);
        List movieList = this.movieService.findAllMovie(type, title, status, startAt, endAt);
        return movieList;
    }

    @RequestMapping(value={"/a/u/movie/status/{id}"}, method={RequestMethod.PUT})
    public Long updateStatus(@PathVariable(value="id") Long id, @RequestBody Movie movie) {
        log.info("service\u6a21\u5757 \u66f4\u65b0movie\u4e0a\u4e0b\u67b6 id={}", (Object)id);
        return this.movieService.updateStatus(id, movie);
    }

    @PutMapping(value={"/a/u/movie/list"})
    Long updateList(@RequestBody List<Movie> movieList) {
        log.info("service\u6a21\u5757 movie\u6279\u91cf\u66f4\u65b0 size={}", (Object)movieList.size());
        return this.movieService.updateList(movieList);
    }
}

