/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.controller;

import com.ptteng.iqiyi.admin.model.Module;
import com.ptteng.iqiyi.admin.service.ModuleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ModuleController {
    private static final Logger log = LoggerFactory.getLogger(ModuleController.class);
    @Autowired
    private ModuleService moduleService;

    @GetMapping(value={"/a/u/module/list"})
    public List<Module> findList(@RequestParam(value="page", required=false) Integer page, @RequestParam(value="size", required=false) Integer size) {
        log.info("get module list=====");
        List moduleList = this.moduleService.findList();
        return moduleList;
    }

    @GetMapping(value={"/a/u/module/"})
    public List<Long> findIdsList(@RequestParam(value="page", required=false) Integer page, @RequestParam(value="size", required=false) Integer size) {
        log.info("get module ids list=====");
        List moduleIdsList = this.moduleService.findIdsList();
        return moduleIdsList;
    }

    @GetMapping(value={"/a/u/module/many"})
    public List<Module> getObjectsByIds(@RequestParam(name="mids") List<Long> mids) {
        log.info("getObjectsByIds=====" + mids);
        List moduleList = this.moduleService.getObjectsByIds(mids);
        return moduleList;
    }

    @PostMapping(value={"/a/u/module"})
    public Long insertModule(@RequestBody Module module) {
        Long id = this.moduleService.insertModule(module);
        log.info("add module======" + id);
        return id;
    }

    @DeleteMapping(value={"/a/u/module/{id}"})
    public Long deleteById(@PathVariable(value="id") Long id) {
        Long result = this.moduleService.deleteById(id);
        log.info("delete module=====" + id);
        return result;
    }

    @PutMapping(value={"/a/u/module/{id}"})
    public Long updateByPrimaryKeySelective(@RequestBody Module module, @PathVariable(value="id") Long id) {
        log.info("update module====" + module);
        Long result = this.moduleService.updateByPrimaryKeySelective(module, id);
        log.info("module update result======", (Object)result);
        return result;
    }

    @GetMapping(value={"/a/u/module/{mid}"})
    public Module selectById(@PathVariable(value="mid") Long mid) {
        log.info("\u67e5\u8be2\u6a21\u5757\u8be6\u7ec6 id={}", (Object)mid);
        Module module = this.moduleService.selectById(mid);
        return module;
    }

    @GetMapping(value={"/a/u/multi/module"})
    List<Module> findListbyIds(@RequestParam(name="ids") List<Long> ids) {
        log.info("findListbyIds=====" + ids);
        List moduleList = this.moduleService.findListbyIds(ids);
        log.info("moduleList======" + moduleList.size());
        return moduleList;
    }
}

